package com.rocogz.syy.activity.dto.send.request;

import lombok.Data;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;

/**
 * @author 尹世豪
 * @Description:  参与赠送活动记录请求dto
 * @Package com.rocogz.syy.activity.dto.send.request
 * @date 2021/8/11 9:07
 * @Copyright © 广州大诚若谷信息科技有限公司
 */
@Data
@Accessors(chain = true)
public class SendActivityJoinLogRequestDto {
    private static final String ERR_MESSAGE = "不能为空";

    /**
     * 用户编码
     */
    @NotBlank(message = "用户编码" + ERR_MESSAGE)
    private String userCode;

    /**
     * 用户手机号
     */
    @NotBlank(message = "用户手机号" + ERR_MESSAGE)
    private String userPhone;

    /**
     * 用户openid
     */
    @NotBlank(message = "用户openid" + ERR_MESSAGE)
    private String userOpenid;

    /**
     * 活动编码
     */
    @NotBlank(message = "活动编码" + ERR_MESSAGE)
    private String activityCode;

    /**
     * 订单编码
     */
    @NotBlank(message = "订单编码" + ERR_MESSAGE)
    private String orderCode;

    /**
     * 到账金额
     */
    @NotNull(message = "到账金额" + ERR_MESSAGE)
    private BigDecimal receivedAmount;
}
