package com.rocogz.syy.activity.dto.send.request;

import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.validator.constraints.Length;

import javax.validation.Valid;
import javax.validation.constraints.*;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

/**
 * @author djt
 * @date 2021/8/12
 */
@Data
@Accessors(chain = true)
public class BaseSendActivitySaveReq {

    /**
     * 活动名称
     */
    @NotBlank(message = "活动名称不能为空")
    @Length(max = 50)
    private String name;

    /**
     * 活动类型(平台活动: PLATFORM_ACTIVE, 主体活动: BODY_ACTIVE )
     */
    @NotBlank(message = "活动类型不能为空")
    @Pattern(regexp = "^(PLATFORM_ACTIVE|BODY_ACTIVE)$")
    private String type;

    /**
     * 投放平台编码
     */
    @NotBlank(message = "投放平台编码不能为空")
    private String putPlatformCode;

    /**
     * 投放平台miniAppid
     */
    @NotBlank(message = "投放平台miniAppid不能为空")
    private String putPlatformMiniAppid;

    /**
     * 兑换产品编码
     */
    @NotBlank(message = "兑换产品编码不能为空")
    private String exchangeGoodsCode;

    /**
     * 活动开始时间
     */
    @NotNull(message = "活动开始时间不能为空")
    private LocalDateTime startTime;

    /**
     * 活动结束时间
     */
    @NotNull(message = "活动结束时间不能为空")
    private LocalDateTime endTime;

    /**
     * 排序号
     */
    @NotNull(message = "排序号不能为空")
    private Integer sort;

    /**
     * 活动描述
     */
    @Length(max = 500,message = "活动描述最大字数不能超过500")
    private String description;

    /**
     * 赠送发放主体编码
     */
    @NotBlank(message = "赠送发放主体编码不能为空")
    private String issuingBodyCode;


    /**
     * 赠送面值比例
     */
    @DecimalMin("0.01")
    @NotNull(message = "赠送面值比例不能为空")
    private BigDecimal sendRatio;

    /**
     * 赠送最大面值
     */
    @DecimalMin("1")
    @NotNull(message = "赠送最大面值不能为空")
    private BigDecimal sendMaxAmount;

    /**
     * 赠送最小面值
     */
    @DecimalMin("1")
    @NotNull(message = "赠送最小面值不能为空")
    private BigDecimal sendMinAmount;

    /**
     * 赠送产品名称(前端页面展示时显示)
     */
    @NotNull(message = "赠送产品名称不能为空")
    @Length(max = 50)
    private String sendGoodsName;

    /**
     * 赠送产品
     */
    @Valid
    @NotEmpty(message = "赠送产品不能为空")
    private List<SendActivityGoodsSaveItem> goodsItems;

    /**
     * 创建人username
     */
    private String username;

    /**
     * 投放平台名称
     */
    private String putPlatformName;

    /**
     * 发放主体名称
     */
    private String issuingBodyName;

    /**
     * 兑换产品名称
     */
    private String exchangeGoodsName;



}
