package com.rocogz.syy.activity.entity.reo;

import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import static com.rocogz.syy.activity.constant.ActivityConstant.ReoProductNature;

/**
 * <p>
 * 权益线上领取活动-领取记录明细表
 * </p>
 *
 * @author ranxiangfu
 * @since 2022-01-11
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("activity_reo_receive_record_item")
public class ActivityReoReceiveRecordItem extends IdEntity {

    private static final long serialVersionUID=1L;

    /**
     * 活动领取记录编码
     */
    private String recordCode;

    /**
     * 活动领取记录明细编码
     */
    private String recordItemCode;

    /**
     * 产品性质
     * @see ReoProductNature#REO_PRODUCT_NATURE_SCM
     */
    private String productNature;

    /**
     * 产品编号(实物产品编号/合作客户产品编码)
     */
    private String productCode;

    /**
     * 产品名称
     */
    private String productName;

    /**
     * 产品图片
     */
    private String productImg;

    /**
     * 产品面值
     */
    private BigDecimal productFaceValue;

    /**
     * 产品数量
     */
    private Integer productQuantity;

    /**
     * 领取时间
     */
    private LocalDateTime createTime;

    /**
     * 订单编号
     */
    private String orderCode;

    /**
     * 完成时间
     */
    private LocalDateTime finishTime;

    /**
     * 错误信息(调用其他服务下单时报的错误信息)
     */
    private String errorMsg;

}
