package com.rocogz.syy.activity.dto.reo;

import lombok.Data;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotBlank;

/**
 * @author 尹世豪
 * @Description:  线上领取权益请求dto
 * @Package com.rocogz.syy.activity.dto.send.request
 * @date 2021/8/11 9:07
 * @Copyright © 广州大诚若谷信息科技有限公司
 */
@Data
@Accessors(chain = true)
public class ReoActivityOrderRequestDto {
    private static final String ERR_MESSAGE = "不能为空";

    /**
     * 用户编码
     */
    @NotBlank(message = "用户编码" + ERR_MESSAGE)
    private String userCode;

    /**
     * 用户手机号
     */
    @NotBlank(message = "用户手机号" + ERR_MESSAGE)
    private String userPhone;

    /**
     * 活动编码
     */
    @NotBlank(message = "活动编码" + ERR_MESSAGE)
    private String activityCode;

    /**
     * 活动领取记录编码
     */
    @NotBlank(message = "活动领取记录编码" + ERR_MESSAGE)
    private String recordCode;

    /**
     * 投放平台编码
     */
    @NotBlank(message = "投放平台编码" + ERR_MESSAGE)
    private String launchPlatformCode;

    /**
     * 投放平台miniAppid
     */
    @NotBlank(message = "投放平台miniAppid" + ERR_MESSAGE)
    private String launchPlatformMiniAppid;

    /**
     * 赠送发放主体编码
     */
    @NotBlank(message = "赠送发放主体编码" + ERR_MESSAGE)
    private String issuingBodyCode;
}
