package com.rocogz.syy.activity.entity.reo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.time.LocalDateTime;
import java.util.List;

import static com.rocogz.syy.activity.constant.ActivityConstant.ReoRecordAddressStatus;

/**
 * <p>
 * 权益线上领取活动-领取记录表
 * </p>
 *
 * @author ranxiangfu
 * @since 2022-01-11
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("activity_reo_receive_record")
public class ActivityReoReceiveRecord extends IdEntity {

    private static final long serialVersionUID=1L;

    /**
     * 活动编码
     */
    private String activityCode;

    /**
     * 活动领取记录编码
     */
    private String recordCode;

    /**
     * 领取用户编码
     */
    private String userCode;

    /**
     * 领取用户手机号
     */
    private String userPhone;

    /**
     * 礼包编码
     */
    private String giftCode;

    /**
     * 礼包名称
     */
    private String giftName;

    /**
     * 礼包产品数量
     */
    private Integer giftNum;

    /**
     * 车架号后六位
     */
    private String lastSixVinNo;

    /**
     * 身份证号后六位
     */
    private String lastSixIdNo;

    /**
     * 地址状态
     * @see ReoRecordAddressStatus
     */
    private String addressStatus;


    /**
     * 领取时间
     */
    private LocalDateTime receiveTime;

    /**
     * 明细记录
     */
    @TableField(exist = false)
    public List<ActivityReoReceiveRecordItem> items;


}
