package com.rocogz.syy.activity.entity.reo;

import java.math.BigDecimal;

import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.common.entity.IdEntity;
import java.time.LocalDateTime;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 权益线上领取活动-领取人清单信息表
 * </p>
 *
 * @author ranxiangfu
 * @since 2022-01-11
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("activity_reo_receiver_info")
public class ActivityReoReceiverInfo extends IdEntity {

    private static final long serialVersionUID=1L;

    /**
     * 活动编码
     */
    private String activityCode;

    /**
     * 车架号后六位
     */
    private String lastSixVinNo;

    /**
     * 身份证号后六位
     */
    private String lastSixIdNo;

    /**
     * 车牌号码
     */
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String licensePlateNumber;

    /**
     * 是否已领取
     */
    private Boolean received;

    /**
     * 领取用户编码
     */
    private String userCode;

    /**
     * 领取用户手机号
     */
    private String userPhone;

    /**
     * 领取时间
     */
    private LocalDateTime receiveTime;

    /**
     * 领取礼包最大限额
     */
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private BigDecimal receiveGiftWorthMaxLimit;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 创建人
     */
    private String createUser;

    /**
     * 更新时间
     */
    private LocalDateTime updateTime;

    /**
     * 更新人
     */
    private String updateUser;


}
