package com.rocogz.syy.activity.entity.invite;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.activity.entity.reo.ActivityReoInfo;
import com.rocogz.syy.activity.entity.sign.ActivitySignJoinLog;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * <p>
 * 客户邀约到店登记管理表
 * </p>
 *
 * @author yinshihao
 * @since 2022-09-08
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("activity_invite_registration_management")
public class ActivityInviteRegistrationManagement extends IdEntity {

    private static final long serialVersionUID=1L;

    /**
     * 邀约编号
     */
    private String code;

    /**
     * 发放主体编号
     */
    private String issuingBodyCode;

    /**
     * 发放主体名称
     */
    @TableField(exist = false)
    private String issuingBodyName;

    /**
     * 发放主体简称
     */
    @TableField(exist = false)
    private String issuingBodyAbbreviation;

    /**
     * 客户名称
     */
    private String customerName;

    /**
     * 客户手机号
     */
    private Integer customerPhone;

    /**
     * 客户身份描述
     */
    private String customerIdentityDescription;

    /**
     * 客户说明
     */
    private String customerExplain;

    /**
     * 预约到店日期
     */
    private LocalDate appointmentArrivalDate;

    /**
     * 预约到店时间段(NOT_MORNING_OR_AFTERNOON:不定上下午,MORNING:上午,AFTERNOON:下午)
     * @see com.rocogz.syy.activity.constant.ActivityConstant.AppointmentArrivalTimePart
     */
    private String appointmentArrivalTimePart;

    /**
     * 邀约活动类型(ENTER_INTO_ACTIVITIES:参加活动,MAINTAIN:保养,OTHER:其他)
     * @see com.rocogz.syy.activity.constant.ActivityConstant.InviteActivityType
     */
    private String inviteActivityType;

    /**
     * 活动编号
     */
    private String activityCode;

    /**
     * 活动信息
     */
    @TableField(exist = false)
    private ActivityReoInfo activityReoInfo;

    /**
     * 活动参与记录编号
     */
    private String activityParticipateInLogCode;

    /**
     * 活动参与记录
     */
    @TableField(exist = false)
    private ActivitySignJoinLog activitySignJoinLog;

    /**
     * 邀约人姓名
     */
    private String inviteeName;

    /**
     * 邀约人手机号
     */
    private Integer inviteePhone;

    /**
     * 备注
     */
    private String remark;

    /**
     * 签到状态(SIGN_IN_PENDING:待签到,SIGN_IN_NOT:没签到,SIGN_IN_SUCCESS:已签到)
     * @see com.rocogz.syy.activity.constant.ActivityConstant.SignInStatus
     */
    private String signInStatus;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 创建人
     */
    private String createUser;

    /**
     * 更新时间
     */
    private LocalDateTime updateTime;

    /**
     * 更新人
     */
    private String updateUser;

    /**
     * 客户邀约到店登记管理操作项(ADD:新增邀约,EDIT:编辑,SIGN_IN:签到)
     * @see com.rocogz.syy.activity.constant.ActivityConstant.InviteRegistrationManagementOperation
     */
    @TableField(exist = false)
    private String operation;
}
