package com.rocogz.syy.activity.entity.reo;


import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.activity.enumeration.GrantWayEnum;
import com.rocogz.syy.activity.enumeration.LimitRuleEnum;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Getter;
import lombok.Setter;
import org.springframework.util.CollectionUtils;

import java.time.LocalDate;
import java.util.List;

/**
 * 签名活动 扩展信息
 *
 * @author zhangmin
 */
@TableName("activity_sigin_act_info")
@Setter
@Getter
public class SiginActInfo extends IdEntity {

    private String activityCode;

    /**
     * 活动参与规则限制：
     * （1）不限制：任何人都可以参与活动
     * （2）白名单：在【客户邀约到店】中有邀约记录的客户手机号才可参与活动
     */
    private LimitRuleEnum joinLimit;

    /**
     * 礼品发放规则：活动通用发放规则
     */
    private LimitRuleEnum grantRule;

    /**
     * 礼品发放方式
     */
    private GrantWayEnum grantWay;

    /**
     * 活动场地地址详情
     */
    private String addressDetail;

    /**
     * 活动场地: 经度
     */
    private String longitude;

    /**
     * 活动场地: 纬度
     */
    private String latitude;

    /**
     * 礼品发放账号：用户名
     */
    private String grantAccountUser;

    /**
     * 礼品发放账号:名字
     */
    private String grantAccountName;

    /**
     * 礼品发放账号：手机号
     */
    private String grantAccountMobile;

    /**
     * 活动每日最新发放规则配置列表（从活动开始 - 活动截止日期）
     */
    @TableField(exist = false)
    private List<SiginActPerDayGrantRuleConfig> currentGrantRuleList;

    /**
     * 当前最新 赠送礼品配置
     */
    @TableField(exist = false)
    private List<SiginActGiftConfig> currentGiftList;

    /**
     * 活动当日的发放规则配置
     */
    @TableField(exist = false)
    private SiginActPerDayGrantRuleConfig  todayGrantRule;

}
