package com.rocogz.syy.activity.entity.send;

import com.baomidou.mybatisplus.annotation.TableField;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

/**
 * <p>
 * 活动参与记录
 * </p>
 *
 * @author yinshihao
 * @since 2021-08-11
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
public class ActivitySendJoinLog extends IdEntity {

    private static final long serialVersionUID=1L;
    /**
     * 参与记录编码
     */
    private String code;

    /**
     * 订单编码
     */
    private String orderCode;

    /**
     * 用户编码
     */
    private String userCode;

    /**
     * 用户手机号
     */
    private String userPhone;

    /**
     * 用户openid
     */
    private String userOpenid;

    /**
     * 活动编码
     */
    private String activityCode;

    /**
     * 赠送面值
     */
    private BigDecimal sendAmount;

    /**
     * 到账金额
     */
    private BigDecimal receivedAmount;

    /**
     * 兑换积分值
     */
    private BigDecimal exchangePointValue;

    /**
     * 状态
     */
    private String status;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;


    /**
     * 更新时间
     */
    private LocalDateTime updateTime;

    /**
     * 完成时间
     */
    private LocalDateTime finishTime;

    /**
     * 撤销时间
     */
    private LocalDateTime revertTime;

    /**
     * 赠送活动参与明细列表
     */
    @TableField(exist = false)
    private List<ActivitySendJoinDetail> joinDetailList;

    /**
     * 赠送活动基本信息
     */
    @TableField(exist = false)
    private ActivitySendMainInfo sendMainInfo;
}
