package com.rocogz.syy.activity.entity.reo;

import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import static com.rocogz.syy.activity.constant.ActivityConstant.ReoProductNature;

/**
 * <p>
 * 权益线上领取活动-礼包-产品信息表
 * </p>
 *
 * @author ranxiangfu
 * @since 2022-01-11
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("activity_reo_gift_product_info")
public class ActivityReoGiftProductInfo extends IdEntity {

    private static final long serialVersionUID=1L;

    /**
     * 活动编号
     */
    private String activityCode;

    /**
     * 礼包信息编号
     */
    private String giftCode;

    /**
     * 产品编码(合作客户产品/实物商品编码)
     */
    private String productCode;

    /**
     * 产品名称
     */
    private String productName;

    /**
     * 产品图片
     */
    private String productImg;

    /**
     * 产品面额
     */
    private BigDecimal productFaceValue;

    /**
     * 产品价值
     */
    private BigDecimal productWorth;

    /**
     * 产品数量
     */
    private Integer productQuantity;

    /**
     * 产品性质
     * @see ReoProductNature#REO_PRODUCT_NATURE_SCM
     */
    private String productNature;

    /**
     * 产品类型
     */
    private String productType;

    /**
     * 排序值
     */
    private Integer sortNum;

    /**
     * 状态
     */
    private String status;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 创建人
     */
    private String createUser;

    /**
     * 更新时间
     */
    private LocalDateTime updateTime;

    /**
     * 更新人
     */
    private String updateUser;
}
