package com.rocogz.syy.activity.dto.invite.request;

import lombok.Data;
import lombok.experimental.Accessors;

import java.time.LocalDate;
import java.util.List;

/**
 * @Description: 客户邀约到店登记管理分頁查询条件DTO
 * @date：2022/9/9
 * @author：yinshihao
 */
@Data
@Accessors(chain = true)
public class InviteRegistrationManagementPageQueryDto {

    /**
     * 发放主体编号列表
     */
    private List<String> issuingBodyCodeList;

    /**
     * 邀约编号
     */
    private String code;

    /**
     * 客户手机号
     */
    private String customerPhone;

    /**
     * 客户名称
     */
    private String customerName;

    /**
     * 预约到店日期-开始时间
     */
    private String startAppointmentArrivalDate;

    /**
     * 预约到店日期-开始时间
     */
    private String endAppointmentArrivalDate;

    /**
     * 邀约人姓名
     */
    private String inviteeName;

    /**
     * 活动编号
     */
    private String activityCode;

    /**
     * 签到状态(SIGN_IN_PENDING:待签到,SIGN_IN_NOT:没签到,SIGN_IN_SUCCESS:已签到)
     * @see com.rocogz.syy.activity.constant.ActivityConstant.SignInStatus
     */
    private String signInStatus;

    /**
     * 当前时间
     */
    private LocalDate now;

    /**
     * 当前页
     */
    private Integer page;

    /**
     * 每页记录数
     */
    private Integer limit;

    /**
     * 是否导出操作
     */
    private Boolean export;
}
