package com.rocogz.syy.activity.entity.reo;

import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.rocogz.syy.activity.enumeration.LimitRuleEnum;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Getter;
import lombok.Setter;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Objects;

/**
 * @author zhangmin
 * 签到活动每日礼品发放规则配置
 */
@TableName("activity_sigin_act_perday_rule_config")
@Setter
@Getter
@JsonIgnoreProperties(ignoreUnknown = true)
public class SiginActPerDayGrantRuleConfig extends IdEntity {

    private String activityCode;

    /**
     * 发放日期,即活动日期
     */
    private LocalDate grantDate;

    /**
     * 礼品发放规则限制：
     * （1）不限制：只要参与了签到的人都送礼品
     * （2）白名单：在【客户邀约到店】中有邀约记录的手机号参与活动后才发放礼品
     */
    private LimitRuleEnum limitRule;

    /**
     * 更新人
     */
    private String updateUser;

    /**
     * 更新时间
     */
    private LocalDateTime updateTime;


    private Integer version;


    /**
     * 是否可以修改
     */
    public boolean isEditable() {
        if(grantDate == null) {
            return false;
        }

        // grantDate>=today的可以修改
        return !LocalDate.now().isAfter(grantDate);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        SiginActPerDayGrantRuleConfig that = (SiginActPerDayGrantRuleConfig) o;
        return Objects.equals(activityCode, that.activityCode) &&
                Objects.equals(grantDate, that.grantDate) &&
                limitRule == that.limitRule;
    }

    @Override
    public int hashCode() {
        return Objects.hash(activityCode, grantDate, limitRule);
    }
}
