package com.rocogz.syy.activity.entity.sign;

import com.baomidou.mybatisplus.annotation.TableField;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.time.LocalDateTime;

/**
 * 活动参与记录
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
public class ActivitySignJoinLog extends IdEntity {

    /**
     * 活动参与记录编号
     */
    private String code;

    /**
     * 发放主体编号
     */
    private String issuingBodyCode;

    /**
     * 发放主体名称
     */
    private String issuingBodyName;

    /**
     * 投放平台编码
     */
    private String launchPlatformCode;

    /**
     * 投放平台miniAppid
     */
    private String launchPlatformMiniAppid;

    /**
     * 投放平台名称/小程序名称
     */
    @TableField(exist = false)
    private String launchPlatformName;


    /**
     * 活动编号
     */
    private String activityCode;

    /**
     * 签到人名称
     */
    private String userName;

    /**
     * 签到人手机号
     */
    private String userMobile;

    /**
     * 签到人微信昵称
     */
    private String userWechatNickname;

    /**
     * 签到人openId
     */
    private String userOpenId;

    /**
     * 签到人头像
     */
    private String userHeadPortrait;

    /**
     * 签到地址
     */
    private String userAddress;

    /**
     * 纬度
     */
    private String latitude;

    /**
     * 经度
     */
    private String longitude;

    /**
     * 签到时间
     */
    private LocalDateTime signInTime;

    /**
     * 签到留言
     */
    private String leaveMessage;

    /**
     * 是否邀约
     */
    private String isInvite;

    /**
     * 是否发放礼品
     */
    private String isGiveGift;

    /**
     * 邀约编号
     */
    private String inviteCode;

    /**
     * 礼品发放申请单号
     */
    private String giftApplyCode;

    /**
     * 礼品名称
     */
    @TableField(exist = false)
    private String goodsName;

    /**
     * 礼品总面额
     */
    @TableField(exist = false)
    private String goodsFaceValue;

    /**
     * 礼品发放情况
     */
    @TableField(exist = false)
    private String goodsGrantStatus;

    /**
     * MQ是否发送成功
     */
    private String mqSuccess;

    /**
     * 失败信息
     */
    private String errorMessage;

    /**
     * 礼品快照单号
     */
    private String snapshotCode;


}
