package com.rocogz.syy.activity.entity.reo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Getter;
import lombok.Setter;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * @author zhangmin
 * 签到活动配置的赠送礼品
 */
@TableName("activity_sigin_act_gift_config")
@Setter
@Getter
@JsonIgnoreProperties(ignoreUnknown = true)
public class SiginActGiftConfig extends IdEntity {

    private String activityCode;

    /**
     * 客户产品编号
     */
    private String customerProductCode;

    /**
     * 客户产品名称
     */
    private String customerProductName;

    /**
     * 平台产品类型:例如：OIL_CARD_DIGITAL_YES
     */
    private String productType;

    /**
     * 面额/市场价 【积分/直充】支持修改面额
     */
    private BigDecimal faceValue;

    /**
     * 赠送数量 非【积分/直充】面额不可变更，支持数量修改
     */
    private Integer quantity;

    /*
     * 使用有效期 （天）
     */
    private Integer useValidity;

    /**
     * 产品内容
     */
    private String  content;

    /**
     * 赠送状态：启用/停用 OPEN/LOCK
     */
    private String givenStatus;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 创建人
     */
    private String createUser;


    /**
     * 版本号，每次编辑后,版本号+1
     */
    private Integer version;


    /**
     * 是否被删除标记，如果编辑时,如果第一次是送礼品，而第二次又修改成不送礼品了，则也需要插入1条虚拟礼品数据用来维护增加版本号（此虚拟数据标记为删除）
     */
    private Boolean deleted;


    /**
     * 发放主体产品状态：实时读取 主体产品的状态 例如：UP_LIST / DOWN_LIST
     * @see merchantIssuingbodyCustomerGoods#status
     */
    @TableField(exist = false)
    private String issuingBodyProdStatus;

    /**
     * 客户产品状态: 实时读取 客户产品的状态 例如：UP_LIST / DOWN_LIST
     *
     * @see CustomerGoods#status
     */
    @TableField(exist = false)
    private String customerProductStatus;


}
