package com.rocogz.syy.activity.entity.reo;

import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.experimental.Accessors;

import java.time.LocalDateTime;

/**
 * @Description: reo活动信息操作记录实体
 * @date：2022/1/17
 * @author：huangdeyi
 */
@Data
@Accessors(chain = true)
@TableName("activity_reo_operation_log")
public class ActivityReoOperationLog extends IdEntity {

    private static final long serialVersionUID = -11115690177359792L;

    /**
    * 唯一识别码
    */
    private String identifyCode;
    
    /**
    * 变更信息
    */
    private String info;
    
    /**
    * 操作类型
    */
    private String operationType;
    
    /**
    * 操作人账户名
    */
    private String operationUsername;
    
    /**
    * 操作人姓名
    */
    private String operationUserNickname;
    
    /**
    * 操作时间
    */
    private LocalDateTime operationTime;
}