package com.rocogz.syy.activity.entity.reo.group;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Getter;
import lombok.Setter;

import java.math.BigDecimal;
import java.util.List;

@TableName("activity_group_act_info")
@Setter
@Getter
@JsonIgnoreProperties(ignoreUnknown = true)
public class ActivityGroupActInfo extends IdEntity {

    /**
     * 活动编码
     */
    private String activityCode;
    /**
     * 产品名称
     */
    private String productName;
    /**
     * 产品编码
     */
    private String productCode;
    /**
     * 产品价格
     */
    private String productPrice;
    /**
     * 产品数量
     */
    private String productQuantity;
    /**
     * 产品说明
     */
    private String productIntroduction;
    /**
     * 是否需要定金
     */
    private boolean need_deposit;
    /**
     * 定金
     */
    private BigDecimal deposit;
    /**
     * 参团提示
     */
    private String groupTips;
    /**
     * 活动页banner图
     */
    private String activityView;

    /**
     * 阶梯配置
     */
    @TableField(exist = false)
    private List<ActivityGroupActStage> stageList;



}
