package com.rocogz.syy.activity.entity.reo.group;

import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.rocogz.syy.activity.constant.ActivityConstant;
import com.rocogz.syy.common.entity.UserTimeEntity;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 团购活动参与记录表
 * @Author 陈煜敏
 * @Date 2022/11/18 09:26
 * @Copyright © 广州大诚若谷信息科技有限公司
 */
@TableName("activity_group_participate")
@Setter
@Getter
@Accessors(chain = true)
@JsonIgnoreProperties(ignoreUnknown = true)
public class ActivityGroupParticipants extends UserTimeEntity implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 记录编码
     */
    private String code;

    /**
     * 发放主体编码
     */
    private String issuingBodyCode;

    /**
     * 发放主体名称
     */
    private String issuingBodyName;

    /**
     * 投放平台miniAppid
     */
    private String launchPlatformMiniAppid;

    /**
     * 投放平台名称/小程序名称
     */
    private String launchPlatformName;

    /**
     * 活动编码
     */
    private String activityCode;

    /**
     * 活动名称
     */
    private String activityName;
    /**
     * 产品名称
     */
    private String productName;
    /**
     * 产品编码
     */
    private String productCode;
    /**
     * 产品价格
     */
    private String productPrice;
    /**
     * 产品数量
     */
    private String productQuantity;

    /**
     * 预约手机号
     */
    private String reserveMobile;

    /**
     * 参与人微信openID
     */
    private String openId;

    /**
     * 参与时参团人数
     */
    private Integer reserveGroupNum;

    /**
     * 定金
     */
    private BigDecimal deposit;

    /**
     * 核销时参团人数
     */
    private Integer verificationGroupNum;

    /**
     * 客户手机号
     * 核销时填写的客户手机号
     */
    private String customerMobile;

    /**
     * 客户姓名
     * 核销时填写的客户姓名
     */
    private String customerName;

    /**
     * 实际到手价格
     */
    private BigDecimal actualPrice;

    /**
     * 优惠金额
     */
    private BigDecimal discountAmount;

    /**
     * 优惠折扣
     */
    private BigDecimal discount;

    /**
     * 核销状态(正常：0，已核销：1)
     * @see ActivityConstant.ActivityGroupParticipantsStatus
     */
    private String status;

}
