package com.rocogz.syy.activity.entity.reo.receive;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.rocogz.syy.activity.constant.ActivityConstant;
import com.rocogz.syy.activity.entity.reo.ActivityReoInfo;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * <p>
 * 领取审核活动配置的赠送礼品（四川中银宝员工内部活动）
 * </p>
 *
 * @author zhangmin
 * @since 2023-04-12
 */
@JsonIgnoreProperties(ignoreUnknown = true)
@Setter @Getter
@Accessors(chain = true)
public class ActivityReceiveAuditGiftConfig extends IdEntity {

    /**
     * 活动编码
     *
     * @see ActivityReoInfo#code
     */
    private String activityCode;

    /**
     * 客户产品编号
     */
    private String customerProductCode;

    /**
     * 客户产品名称
     */
    private String customerProductName;

    /**
     * 产品类型
     */
    private String productType;

    /**
     * 面额/市场价
     */
    private BigDecimal faceValue;

    /**
     * 数量
     */
    private Integer quantity;

    /**
     * 使用有效期天数
     */
    private Integer useValidity;

    /**
     * 产品内容
     */
    private String content;

    /**
     * 赠送状态：启用(OPEN)/ 停用 (LOCK)
     * @see ActivityConstant.DictData#COMMON_STATUS_OPEN_CODE
     */
    private String givenStatus;


}
