package com.rocogz.syy.activity.entity.reo.receive;

import com.baomidou.mybatisplus.annotation.TableField;
import com.rocogz.syy.activity.entity.reo.ActivityReoInfo;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * <p>
 * 川分员工之家 领取验证活动配置信息表
 * </p>
 *
 * @author zhangmin
 * @since 2023-04-12
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class ActivityReceiveAuditConfig extends IdEntity {

    /**
     * 活动编码
     * @see ActivityReoInfo#code
     */
    private String activityCode;

    /**
     * 参与活动后是否自动审核通过
     */
    private Boolean autoAuditPass;

    /**
     * 如果是自动审核，则在参与活动N天后自动审核通过
     */
    private Integer autoPassDay;


    /**
     * 配置的已启用产品名称,多个产品名称逗号分隔
     */
    public String productNames;

    /**
     * 已启用的 总产品数量,总产品分类数量,即配置了几个产品编号就是几
     */
    private Integer totalQuantity;

    /**
     * 已启用的 总产品面值 = sum(各个产品的数量 * 该产品的面值)
     */
    private BigDecimal totalFaceValue;



    // ================== 下面都是非PO属性

    /**
     * 活动配置的产品
     */
    @TableField(exist = false)
    private List<ActivityReceiveAuditGiftConfig> giftList;

}
