package com.rocogz.syy.activity.entity.reo.receive;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.rocogz.syy.activity.constant.ActivityConstant;
import com.rocogz.syy.activity.entity.reo.ActivityReoInfo;
import com.rocogz.syy.activity.enumeration.JoinRecordAuditWayEnum;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.*;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;

/**
 * <p>
 * 川分员工之家 领取审核活动参与记录
 * </p>
 *
 * @author zhangmin
 * @since 2023-04-12
 */
@Setter @Getter
@NoArgsConstructor
@Accessors(chain = true)
@JsonIgnoreProperties(ignoreUnknown = true)
public class ActivityReceiveAuditJoinRecord extends ActivityReceiveJoiner {

    /**
     * 参加后动时的 活动名称,因为活动名称可以下架修改
     */
    private String activityName;

    /**
     * 参与年份，例如：2023 用来控制在该年份1个手机号只能参与活动1次
     */
    private Integer joinYear;

    /**
     * 审核状态,待审核、审核通过、审核不通过
     * @see ActivityConstant.DictReceiveActivityJoinRecordAuditStatus#PENDING
     */
    private String auditStatus;

    /**
     * 审核方式：自动审核，人工审核
     */
    private JoinRecordAuditWayEnum auditWay;

    /**
     * 如果是自动审核，系统时间 >= autoAuditStartTime, 则自动审核通过
     * autoAuditStartTime = joinTime + NDay
     */
    private LocalDateTime autoAuditStartTime;

    /**
     * 最后审核时间
     */
    private LocalDateTime lastAuditTime;

    /**
     * 最后审核手机号
     */
    private String lastAuditorMobile;

    /**
     * 最后审核人名字
     */
    private String lastAuditorName;


    /**
     * 供应链下游订单编号
     */
    private String scmOrderCode;

    /**
     * 供应链下游订单 重试次数
     */
    private Integer scmOrderRetryNum;

    /**
     * 供应链下游下单失败原因
     */
    private String scmOrderReason;





    // ================== 下面都是非PO属性

    /**
     * 参与的活动信息
     */
    @TableField(exist = false)
    private ActivityReoInfo actInfo;


    /**
     * 该参与记录的审核记录列表
     */
    @TableField(exist = false)
    private List<ActivityReceiveAuditRecord> auditRecordList;
}
