package com.rocogz.syy.activity.entity.reo.receive;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.rocogz.syy.activity.constant.ActivityConstant;
import com.rocogz.syy.activity.entity.reo.ActivityReoInfo;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.*;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * <p>
 * 领取审核活动配置的赠送礼品（四川中银宝员工内部活动）
 * </p>
 *
 * @author zhangmin
 * @since 2023-04-12
 */
@JsonIgnoreProperties(ignoreUnknown = true)
@Setter @Getter
@Accessors(chain = true)
public class ActivityReceiveAuditGiftConfig extends IdEntity {

    /**
     * 活动编码
     *
     * @see ActivityReoInfo#code
     */
    private String activityCode;

    /**
     * 客户产品编号
     */
    private String customerProductCode;

    /**
     * 客户产品名称
     */
    private String customerProductName;

    /**
     * 产品类型
     */
    private String productType;

    /**
     * 客户产品的 面额/市场价
     */
    private BigDecimal faceValue;

    /**
     * 数量
     */
    private Integer quantity;

    /**
     * 使用有效期天数
     */
    private Integer useValidity;

    /**
     * 产品内容
     */
    private String content;

    /**
     * 赠送状态：启用(OPEN)/ 停用 (LOCK)
     * @see ActivityConstant.DictData#COMMON_STATUS_OPEN_CODE
     */
    private String givenStatus;


    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder();
        //格式化成保留三位小数,四舍五入 方便比较
        String faceValueStr = String.format("%.3f",faceValue);
        buf.append("customerProductCode=").append(customerProductCode)
                .append("quantity=").append(quantity)
                .append("faceValue=").append(faceValueStr)
                .append("givenStatus=").append(givenStatus);
        return buf.toString();
    }

}
