package com.rocogz.syy.activity.entity.reo.receive;

import com.rocogz.syy.activity.constant.ActivityConstant;
import com.rocogz.syy.activity.enumeration.JoinRecordAuditWayEnum;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.time.LocalDateTime;

/**
 * <p>
 * 川分员工之家 领取审核活动参与记录的 审核记录
 * </p>
 *
 * @author zhangmin
 * @since 2023-04-12
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class ActivityReceiveAuditRecord extends IdEntity {

    /**
     * 活动编码
     */
    private String activityCode;

    /**
     * 活动参与记录编号
     */
    private String joinCode;

    /**
     * 审核人手机号
     */
    private String auditorMobile;

    /**
     * 审核人名字
     */
    private String auditorName;

    /**
     * 审核方式：自动审核，人工审核
     */
    private JoinRecordAuditWayEnum auditWay;

    /**
     * 审核结果：通过/不通过
     * @see ActivityConstant.DictReceiveActivityJoinRecordAuditStatus#PASS
     */
    private String result;

    /**
     * 审核意见，批注
     */
    private String note;

    /**
     * 审核时间
     */
    private LocalDateTime auditTime;


}
