package com.rocogz.syy.activity.entity.reo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.rocogz.syy.activity.constant.ActivityConstant;
import com.rocogz.syy.activity.entity.reo.group.ActivityGroupActInfo;
import com.rocogz.syy.activity.entity.reo.receive.ActivityReceiveAuditConfig;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.time.LocalDateTime;
import java.util.List;

/**
 * <p>
 * 权益线上领取/签到 活动主信息表
 * </p>
 *
 * @author ranxiangfu
 * @since 2022-01-11
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("activity_reo_info")
@JsonIgnoreProperties(ignoreUnknown = true)
public class ActivityReoInfo extends IdEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 活动编码
     */
    private String code;

    /**
     * 活动名称
     */
    private String name;

    /**
     * 活动类型
     *
     * @see ActivityConstant.DictReoActivityType#REO_ACTIVITY_SIGIN
     */
    private String activityType;

    /**
     * 开始时间
     */
    private LocalDateTime startTime;

    /**
     * 结束时间
     */
    private LocalDateTime endTime;

    /**
     * 投放平台编码
     */
    private String launchPlatformCode;

    /**
     * 投放平台miniAppid
     */
    private String launchPlatformMiniAppid;

    /**
     * 投放平台名称/小程序名称
     */
    @TableField(exist = false)
    private String launchPlatformName;

    /**
     * 投放平台小程序二维码
     */
    @TableField(exist = false)
    private String launchPlatformMiniAppQrUrl;

    /**
     * 发放主体编码
     */
    private String issuingBodyCode;

    /**
     * 发放主体简称
     */
    @TableField(exist = false)
    private String issuingBodyAbbreviation;

    /**
     * 列表图
     */
    private String listView;

    /**
     * 详情图
     */
    private String detailView;


    /**
     * 活动页banner图
     */
    private String bannerView;

    /**
     * 活动分享页图
     */
    private String shareView;


    /**
     * 活动说明
     */
    private String description;

    /**
     * 上架状态
     *
     * @see ActivityConstant.DictData#ACTIVITY_STATUS_DRAFT_CODE
     */
    private String status;

    /**
     * 活动进行状态
     *
     * @see ActivityConstant.DictData#ACTIVITY_PROGRESS_STATUS_NOT_STARTED_CODE
     */
    @TableField(exist = false)
    private String progressStatus;



    /**
     * 参加活动 小程序码 扫描图片地址，小程序菊花码图片url
     */
    private String joinActQrCodeUrl;

    /**
     * 参加活动 小程序码 二维码 对应的编号
     * @see com.rocogz.syy.operation.entity.qr.OperateQr#code
     */
    private String joinActQrCode;

    /**
     * 参加活动扫描小程序码后的 的跳转path，例如：packageE/pages/questionnaire/index?inverstCode=WJ2020061300001
     */
    private String jumpMiniAppPath;

    /**
     *  参加活动扫描小程序码 跳转路径 对应的编号，例如：WF9Q
     *
     * @see com.rocogz.syy.operation.entity.qr.OperateQrParameter#code
     */
    private String jumpCode;


    /**
     * 排序值
     */
    private Integer sortNum;

    /**
     * 备注
     */
    private String remark;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 创建人
     */
    private String createUser;

    /**
     * 更新时间
     */
    private LocalDateTime updateTime;

    /**
     * 更新人
     */
    private String updateUser;


    // ================== 下面都是非PO属性

    /**
     * 创建人名称
     */
    @TableField(exist = false)
    private String createUserNickname;

    /**
     * 更新人名称
     */
    @TableField(exist = false)
    private String updateUserNickname;

    /**
     * 活动礼包信息列表
     */
    @TableField(exist = false)
    private List<ActivityReoGiftInfo> giftInfos;

    /**
     * 签到活动配置信息
     */
    @TableField(exist = false)
    private SiginActInfo siginActInfo;

    /**
     * 团购活动配置信息
     */
    @TableField(exist = false)
    private ActivityGroupActInfo activityGroupActInfo;


    /**
     领取审核活动 （四川中银保员工内部活动）
     */
    @TableField(exist = false)
    private ActivityReceiveAuditConfig receiveActInfo;

}
