package com.rocogz.syy.activity.entity.reo.receive;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.experimental.Accessors;

/**
 * <p>
 * 川分员工之家 领取审核活动参与记录得到的礼品,当参与审核通过后保存得到的礼品
 * </p>
 *
 * @author zhangmin
 * @since 2023-04-12
 */
@Setter
@Getter
@NoArgsConstructor
@Accessors(chain = true)
@JsonIgnoreProperties(ignoreUnknown = true)
public class ActivityReceiveAuditJoinRecordGift extends ActivityReceiveBaseGift {

    /**
     * 参与记录编号
     */
    private String joinCode;

    /**
     * 供应链下游订单编号
     */
    private String scmOrderCode;

    /**
     * 供应链下游订单 重试次数
     */
    private Integer scmOrderRetryNum;

    /**
     * 供应链下游下单失败原因
     */
    private String scmOrderReason;


}
