package com.rocogz.syy.activity.entity.reo.receive;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.math.BigDecimal;

/**
 * 川分员工之家 领取验证活动 礼品基类
 * @author zhangmin
 */
@JsonIgnoreProperties(ignoreUnknown = true)
@Setter @Getter
@Accessors(chain = true)
public abstract class ActivityReceiveBaseGift extends IdEntity {

    /**
     * 客户产品编号
     */
    private String customerProductCode;

    /**
     * 客户产品名称
     */
    private String customerProductName;

    /**
     * 产品类型
     */
    private String productType;

    /**
     * 客户产品的 面额/市场价
     * （1）发放的用户券的 面值 是平台产品市场价,这个地方到底取那个面值需要和需求确认？
     */
    private BigDecimal faceValue;

    /**
     * 数量
     */
    private Integer quantity;

    /**
     * 使用有效期天数
     */
    private Integer useValidity;




}
