package com.rocogz.syy.activity.dto.group;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotBlank;
import java.time.LocalDateTime;

/**
 * 团购活动参与记录表查询DTO
 * @Author 陈煜敏
 * @Date 2022/11/19 09:26
 * @Copyright © 广州大诚若谷信息科技有限公司
 */
@Data
@Accessors(chain = true)
public class ActivityGroupParticipantsQueryDto {

    /**
     * 记录编码
     */
    private String code;

    /**
     * 活动编码
     */
    private String activityCode;

    /**
     * 发放主体编码
     */
    private String issuingBodyCode;

    /**
     * 投放平台miniAppid
     */
    private String launchPlatformMiniAppid;

    /**
     * 预约手机号
     */
    private String reserveMobile;

    /**
     * 客户姓名
     * 核销时填写的客户姓名
     */
    private String customerName;

    /**
     * 创建时间-开始
     */
    private String createTimeStart;

    /**
     * 创建时间-结束
     */
    private String createTimeEnd;

    /**
     * 核销时间-开始
     */
    private String verificationTimeStart;

    /**
     * 核销时间-结束
     */
    private String verificationTimeEnd;

    /**
     * 核销状态(正常：0，已核销：1，待支付：-1)
     */
    private String status;

    /**
     * 当前页码
     */
    Integer page;

    /**
     * 每页数量
     */
    Integer limit;

}
