package com.rocogz.syy.activity.client;

import com.rocogz.syy.activity.dto.group.ActivityGroupParticipantsQueryDto;
import com.rocogz.syy.activity.dto.group.ActivityGroupParticipantsStageDto;
import com.rocogz.syy.activity.dto.invite.request.InviteRegistrationManagementPageQueryDto;
import com.rocogz.syy.activity.dto.reo.*;
import com.rocogz.syy.activity.dto.reo.receiveAudit.ReoReceiveAuditJoinRecordPageSearchDto;
import com.rocogz.syy.activity.dto.send.request.*;
import com.rocogz.syy.activity.dto.send.response.SendActivityJoinLogListResp;
import com.rocogz.syy.activity.dto.sign.SignLogReq;
import com.rocogz.syy.activity.dto.sign.SignLogSearchDto;
import com.rocogz.syy.activity.entity.*;
import com.rocogz.syy.activity.entity.invite.ActivityInviteRegistrationManagement;
import com.rocogz.syy.activity.entity.reo.*;
import com.rocogz.syy.activity.entity.reo.group.ActivityGroupActInfo;
import com.rocogz.syy.activity.entity.reo.group.ActivityGroupParticipants;
import com.rocogz.syy.activity.entity.reo.receive.*;
import com.rocogz.syy.activity.entity.send.ActivitySendGoodsInfo;
import com.rocogz.syy.activity.entity.send.ActivitySendJoinDetail;
import com.rocogz.syy.activity.entity.send.ActivitySendJoinLog;
import com.rocogz.syy.activity.entity.send.ActivitySendMainInfo;
import com.rocogz.syy.activity.entity.sign.ActivitySignGiftSnapshot;
import com.rocogz.syy.activity.entity.sign.ActivitySignJoinLog;
import com.rocogz.syy.activity.entity.zh.wash.car.ActivityZhWashCar;
import com.rocogz.syy.activity.entity.zh.wash.car.ActivityZhWashCarReceiveInfo;
import com.rocogz.syy.activity.entity.zh.wash.car.ActivityZhWashCarReceiveRule;
import com.rocogz.syy.common.PageTable;
import com.rocogz.syy.common.response.Response;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * The interface Activity client service.
 *
 * @author：liangyongtong
 * @since：2020/3/25
 */
public interface IActivityClientService {

    /*********************************************   ranxiangfu 活动基本信息相关接口 start   ********************************************************************/

    /**
     * 分页查询活动基本信息.
     *
     * @param type                       活动类型
     * @param showInList                 是否列表展示
     * @param couponReceivePattern       领券模式
     * @param code                       编码
     * @param name                       名称
     * @param issuingBodyCode            发放主体编码
     * @param prefectureCode             专区编码
     * @param status                     活动上下架状态
     * @param progressStatus             活动进行状态
     * @param activityStartTimeStartTime 活动开始时间范围查询-起始时间
     * @param activityStartTimeEndTime   活动开始时间范围查询-结束时间
     * @param activityEndTimeStartTime   活动结束时间范围查询-开始时间
     * @param activityEndTimeEndTime     活动结束时间范围查询-结束时间
     * @param page                       the page
     * @param limit                      the limit
     * @return the page table
     */
    @GetMapping("/api/activity/activity-basic-info/pageQuery")
    PageTable<ActivityBasicInfo> pageQueryActivityBasicInfo(@RequestParam(value = "type", required = false) String type,
                                                            @RequestParam(value = "showInList", required = false) String showInList,
                                                            @RequestParam(value = "couponReceivePattern", required = false) String couponReceivePattern,
                                                            @RequestParam(value = "code", required = false) String code,
                                                            @RequestParam(value = "name", required = false) String name,
                                                            @RequestParam(value = "issuingBodyCode", required = false) String issuingBodyCode,
                                                            @RequestParam(value = "prefectureCode", required = false) String prefectureCode,
                                                            @RequestParam(value = "status", required = false) String status,
                                                            @RequestParam(value = "progressStatus", required = false) String progressStatus,
                                                            @RequestParam(value = "activityStartTimeStartTime", required = false) String activityStartTimeStartTime,
                                                            @RequestParam(value = "activityStartTimeEndTime", required = false) String activityStartTimeEndTime,
                                                            @RequestParam(value = "activityEndTimeStartTime", required = false) String activityEndTimeStartTime,
                                                            @RequestParam(value = "activityEndTimeEndTime", required = false) String activityEndTimeEndTime,
                                                            @RequestParam(value = "page", defaultValue = "1") Integer page,
                                                            @RequestParam(value = "limit", defaultValue = "20") Integer limit);

    /**
     * Gets activity basic info by id.
     *
     * @param id the id
     * @return the activity basic info by id
     */
    @GetMapping("/api/activity/activity-basic-info")
    Response<ActivityBasicInfo> getActivityBasicInfoById(@RequestParam("id") Integer id);

    /**
     * Gets activity basic info by code.
     *
     * @param code the code
     * @return the activity basic info by code
     */
    @GetMapping("/api/activity/activity-basic-info/getByCode")
    Response<ActivityBasicInfo> getActivityBasicInfoByCode(@RequestParam("code") String code);

    /**
     * Save or update activity basic info response.
     *
     * @param activityBasicInfo the activity basic info
     * @return the response
     */
    @PostMapping("/api/activity/activity-basic-info")
    Response<String> saveOrUpdateActivityBasicInfo(@RequestBody ActivityBasicInfo activityBasicInfo);

    /**
     * Delete activity basic info response.
     *
     * @param id the id
     * @return the response
     */
    @DeleteMapping("/api/activity/activity-basic-info")
    Response deleteActivityBasicInfo(@RequestParam("id") Integer id);

    /**
     * Delete activity basic info by code response.
     *
     * @param code 活动编码
     * @return the response
     */
    @DeleteMapping("/api/activity/activity-basic-info/deleteByCode")
    Response deleteActivityBasicInfoByCode(@RequestParam("code") String code);

    /*********************************************   ranxiangfu 活动基本信息相关接口 end   ********************************************************************/

    /*********************************************   ranxiangfu 活动基准券配置相关接口 start   ********************************************************************/

    /**
     * List activity coupon config response.
     *
     * @param activityCode the activity code
     * @return the response
     */
    @GetMapping("/api/activity/activity-coupon-config/listByActivityCode")
    Response<List<ActivityCouponConfig>> listActivityCouponConfig(@RequestParam(value = "activityCode") String activityCode);

    /**
     * List available activity coupon config response.
     *
     * @param prefectureCode the prefecture code
     * @param activityCode   the activity code
     * @return the response
     */
    @GetMapping("/api/activity/activity-coupon-config/listAvailable")
    Response<List<ActivityCouponConfig>> listAvailableActivityCouponConfig(@RequestParam(value = "prefectureCode") String prefectureCode,
                                                                           @RequestParam(value = "activityCode", required = false) String activityCode);

    /**
     * Gets activity coupon config by id.
     *
     * @param id the id
     * @return the activity coupon config by id
     */
    @GetMapping("/api/activity/activity-coupon-config")
    Response<ActivityCouponConfig> getActivityCouponConfigById(@RequestParam("id") Integer id);

    /**
     * Gets activity coupon config activity code and coupon code.
     *
     * @param activityCode the activity code
     * @param couponCode   the coupon code
     * @return the activity coupon config activity code and coupon code
     */
    @GetMapping("/api/activity/activity-coupon-config/getByActivityCodeAndCouponCode")
    Response<ActivityCouponConfig> getActivityCouponConfigByActivityCodeAndCouponCode(
            @RequestParam("activityCode") String activityCode, @RequestParam("couponCode") String couponCode);

    /**
     * Save or update activity coupon config response.
     *
     * @param activityCouponConfig the activity coupon config
     * @return the response
     */
    @PostMapping("/api/activity/activity-coupon-config")
    Response saveOrUpdateActivityCouponConfig(@RequestBody ActivityCouponConfig activityCouponConfig);

    /**
     * Batch save or update activity coupon config response.
     *
     * @param activityCouponConfigList the activity coupon config list
     * @return the response
     */
    @PostMapping("/api/activity/activity-coupon-config/batchSaveOrUpdate")
    Response batchSaveOrUpdateActivityCouponConfig(@RequestBody List<ActivityCouponConfig> activityCouponConfigList);

    /**
     * Incr activity coupon config receive quantity response.
     *
     * @param activityCode the activity code
     * @param couponCode   the coupon code
     * @return the response
     */
    @PostMapping("/api/activity/activity-coupon-config/incrReceiveQuantity")
    Response incrActivityCouponConfigReceiveQuantity(@RequestParam(value = "activityCode") String activityCode,
                                                     @RequestParam(value = "couponCode") String couponCode);

    /**
     * Delete activity coupon config response.
     *
     * @param id the id
     * @return the response
     */
    @DeleteMapping("/api/activity/activity-coupon-config")
    Response deleteActivityCouponConfig(@RequestParam("id") Integer id);

    /**
     * Delete activity coupon config by ids response.
     *
     * @param idList the id list
     * @return the response
     */
    @DeleteMapping("/api/activity/activity-coupon-config/deleteByIds")
    Response deleteActivityCouponConfigByIds(@RequestParam("idList") List<Integer> idList);

    /**
     * Delete activity coupon config by activity code response.
     *
     * @param activityCode the activity code
     * @return the response
     */
    @DeleteMapping("/api/activity/activity-coupon-config/deleteByActivityCode")
    Response deleteActivityCouponConfigByActivityCode(@RequestParam("activityCode") String activityCode);

    /*********************************************   ranxiangfu 活动基准券配置相关接口 end   ********************************************************************/

    /*********************************************   ranxiangfu 活动日志相关接口 start   ********************************************************************/

    /**
     * Page query activity log page table.
     *
     * @param activityCode the activity code
     * @param page         the page
     * @param limit        the limit
     * @return the page table
     */
    @GetMapping("/api/activity/activity-log/listByActivityCode")
    PageTable<ActivityLog> pageQueryActivityLog(@RequestParam(value = "activityCode") String activityCode,
                                                @RequestParam(value = "page", defaultValue = "1") Integer page,
                                                @RequestParam(value = "limit", defaultValue = "20") Integer limit);

    /**
     * Save activity log response.
     *
     * @param activityLog the activity log
     * @return the response
     */
    @PostMapping("/api/activity/activity-log")
    Response saveActivityLog(@RequestBody ActivityLog activityLog);

    /*********************************************   ranxiangfu 活动日志相关接口 end   ********************************************************************/

    /*********************************************   ranxiangfu 活动领券规则相关接口 start   ********************************************************************/

    /**
     * List activity receive rule response.
     *
     * @param activityCode the activity code
     * @return the response
     */
    @GetMapping("/api/activity/activity-receive-rule/listByActivityCode")
    Response<List<ActivityReceiveRule>> listActivityReceiveRule(@RequestParam(value = "activityCode") String activityCode);

    /**
     * Gets activity receive rule by id.
     *
     * @param id the id
     * @return the activity receive rule by id
     */
    @GetMapping("/api/activity/activity-receive-rule")
    Response<ActivityReceiveRule> getActivityReceiveRuleById(@RequestParam("id") Integer id);

    /**
     * Save or update activity receive rule response.
     *
     * @param activityReceiveRule the activity receive rule
     * @return the response
     */
    @PostMapping("/api/activity/activity-receive-rule")
    Response saveOrUpdateActivityReceiveRule(@RequestBody ActivityReceiveRule activityReceiveRule);

    /**
     * Batch save or update activity receive rule response.
     *
     * @param activityReceiveRuleList the activity receive rule list
     * @return the response
     */
    @PostMapping("/api/activity/activity-receive-rule/batchSaveOrUpdate")
    Response batchSaveOrUpdateActivityReceiveRule(@RequestBody List<ActivityReceiveRule> activityReceiveRuleList);

    /**
     * Delete activity receive rule response.
     *
     * @param id the id
     * @return the response
     */
    @DeleteMapping("/api/activity/activity-receive-rule")
    Response deleteActivityReceiveRule(@RequestParam("id") Integer id);

    /**
     * Delete activity receive rule by ids response.
     *
     * @param idList the id list
     * @return the response
     */
    @DeleteMapping("/api/activity/activity-receive-rule/deleteByIds")
    Response deleteActivityReceiveRuleByIds(@RequestParam("idList") List<Integer> idList);

    /**
     * Delete activity receive rule by activity code response.
     *
     * @param activityCode the activity code
     * @return the response
     */
    @DeleteMapping("/api/activity/activity-receive-rule/deleteByActivityCode")
    Response deleteActivityReceiveRuleByActivityCode(@RequestParam(value = "activityCode") String activityCode);

    /*********************************************   ranxiangfu 活动领券规则相关接口 end   ********************************************************************/

    /*********************************************   ranxiangfu 活动投放专区相关接口 start   ********************************************************************/

    /**
     * List activity available prefecture response.
     *
     * @param activityCode the activity code
     * @return the response
     */
    @GetMapping("/api/activity/activity-available-prefecture/listByActivityCode")
    Response<List<ActivityAvailablePrefecture>> listActivityAvailablePrefecture(@RequestParam(value = "activityCode") String activityCode);

    /**
     * Batch save activity available prefecture response.
     *
     * @param activityAvailablePrefectureList the activity available prefecture list
     * @return the response
     */
    @PostMapping("/api/activity/activity-available-prefecture/batchSave")
    Response batchSaveActivityAvailablePrefecture(@RequestBody List<ActivityAvailablePrefecture> activityAvailablePrefectureList);

    /**
     * Remove activity available prefecture by ids response.
     *
     * @param idList the id list
     * @return the response
     */
    @DeleteMapping("/api/activity/activity-available-prefecture")
    Response deleteActivityAvailablePrefectureByIds(@RequestParam(value = "idList") List<Integer> idList);

    /**
     * Remove activity available prefecture by activity code response.
     *
     * @param activityCode the activity code
     * @return the response
     */
    @DeleteMapping("/api/activity/activity-available-prefecture/deleteByActivityCode")
    Response deleteActivityAvailablePrefectureByActivityCode(@RequestParam(value = "activityCode") String activityCode);

    /*********************************************   ranxiangfu 活动投放专区相关接口 end   ********************************************************************/
    /*********************************************   ranxiangfu 活动优惠券用户领取信息相关接口 start   ********************************************************************/
    /**
     * Save activity user coupon receive info response.
     *
     * @param activityUserCouponReceiveInfo the activity user coupon receive info
     * @return the response
     */
    @PostMapping("/api/activity/activity-user-coupon-receive-info")
    Response saveActivityUserCouponReceiveInfo(@RequestBody ActivityUserCouponReceiveInfo activityUserCouponReceiveInfo);

    /**
     * List user receive coupon info response.
     *
     * @param userCode         the user code
     * @param activityCodeList the activity code list
     * @param couponCodeList   the coupon code list
     * @return the response
     */
    @GetMapping("/api/activity/activity-user-coupon-receive-info/list")
    Response<List<ActivityUserCouponReceiveInfo>> listUserReceiveCouponInfo(@RequestParam("userCode") String userCode,
                                                                            @RequestParam("activityCodeList") List<String> activityCodeList,
                                                                            @RequestParam("couponCodeList") List<String> couponCodeList);

    /**
     * Count user receive coupon num response.
     *
     * @param userCode     the user code
     * @param activityCode the activity code
     * @param couponCode   the coupon code
     * @return the response
     */
    @GetMapping("/api/activity/activity-user-coupon-receive-info/countUserReceiveCouponNum")
    Response<Integer> countUserReceiveCouponNum(@RequestParam(value = "userCode", required = false) String userCode,
                                                @RequestParam("activityCode") String activityCode,
                                                @RequestParam("couponCode") String couponCode);
    /*********************************************   ranxiangfu 活动优惠券用户领取信息相关接口 end   ********************************************************************/

    /*********************************************   ranxiangfu 珠海9块9洗车相关接口 start   ********************************************************************/
    /**
     * Gets activity zh wash car info by code.
     *
     * @param code the code
     * @return the activity zh wash car info by code
     */
    @GetMapping("/api/activity/activity-zh-wash-car/getByCode")
    Response<ActivityZhWashCar> getActivityZhWashCarInfoByCode(@RequestParam("code") String code);

    /**
     * Save or update activity zh wash car response.
     *
     * @param zhWashCar the zh wash car
     * @return the response
     */
    @PostMapping("/api/activity/activity-zh-wash-car")
    Response<String> saveOrUpdateActivityZhWashCar(@RequestBody ActivityZhWashCar zhWashCar);

    /**
     * Delete activity zh wash car response.
     *
     * @param id the id
     * @return the response
     */
    @DeleteMapping("/api/activity/activity-zh-wash-car")
    Response deleteActivityZhWashCar(@RequestParam("id") Integer id);

    /**
     * Delete activity zh wash car by code response.
     *
     * @param code the code
     * @return the response
     */
    @DeleteMapping("/api/activity/activity-zh-wash-car/deleteByCode")
    Response deleteActivityZhWashCarByCode(@RequestParam("code") String code);

    /*********************************************   ranxiangfu 珠海9块9洗车相关接口 end   ********************************************************************/

    /*********************************************   ranxiangfu 珠海9块9洗车领取规则相关接口 start   ********************************************************************/

    /**
     * List activity zh wash car receive rule response.
     *
     * @param activityCode the activity code
     * @return the response
     */
    @GetMapping("/api/activity/activity-zh-wash-car-receive-rule/listByActivityCode")
    Response<List<ActivityZhWashCarReceiveRule>> listActivityZhWashCarReceiveRule(@RequestParam(value = "activityCode") String activityCode);

    /**
     * Gets activity zh wash car receive rule by id.
     *
     * @param id the id
     * @return the activity zh wash car receive rule by id
     */
    @GetMapping("/api/activity/activity-zh-wash-car-receive-rule")
    Response<ActivityZhWashCarReceiveRule> getActivityZhWashCarReceiveRuleById(@RequestParam("id") Integer id);

    /**
     * Save or update activity zh wash car receive rule response.
     *
     * @param activityReceiveRule the activity receive rule
     * @return the response
     */
    @PostMapping("/api/activity/activity-zh-wash-car-receive-rule")
    Response saveOrUpdateActivityZhWashCarReceiveRule(@RequestBody ActivityZhWashCarReceiveRule activityReceiveRule);

    /**
     * Batch save or update activity zh wash car receive rule response.
     *
     * @param activityReceiveRuleList the activity receive rule list
     * @return the response
     */
    @PostMapping("/api/activity/activity-zh-wash-car-receive-rule/batchSaveOrUpdate")
    Response batchSaveOrUpdateActivityZhWashCarReceiveRule(@RequestBody List<ActivityZhWashCarReceiveRule> activityReceiveRuleList);

    /**
     * Delete activity zh wash car receive rule response.
     *
     * @param id the id
     * @return the response
     */
    @DeleteMapping("/api/activity/activity-zh-wash-car-receive-rule")
    Response deleteActivityZhWashCarReceiveRule(@RequestParam("id") Integer id);

    /**
     * Delete activity zh wash car receive rule by ids response.
     *
     * @param idList the id list
     * @return the response
     */
    @DeleteMapping("/api/activity/activity-zh-wash-car-receive-rule/deleteByIds")
    Response deleteActivityZhWashCarReceiveRuleByIds(@RequestParam("idList") List<Integer> idList);

    /**
     * Delete activity zh wash car receive rule by activity code response.
     *
     * @param activityCode the activity code
     * @return the response
     */
    @DeleteMapping("/api/activity/activity-zh-wash-car-receive-rule/deleteByActivityCode")
    Response deleteActivityZhWashCarReceiveRuleByActivityCode(@RequestParam(value = "activityCode") String activityCode);
    /*********************************************   ranxiangfu 珠海9块9洗车领取规则相关接口 end   ********************************************************************/

    /*********************************************   ranxiangfu 珠海9块9洗车优惠券领取记录相关接口 start   ********************************************************************/
    /**
     * Save activity zh wash car receive info response.
     *
     * @param activityUserCouponReceiveInfo the activity user coupon receive info
     * @return the response
     */
    @PostMapping("/api/activity/activity-zh-wash-car-receive-info")
    Response saveActivityZhWashCarReceiveInfo(@RequestBody ActivityZhWashCarReceiveInfo activityUserCouponReceiveInfo);

    /**
     * List user receive coupon info response.
     *
     * @param userCode         the user code
     * @param activityCodeList the activity code list
     * @param couponCodeList   the coupon code list
     * @return the response
     */
    @GetMapping("/api/activity/activity-zh-wash-car-receive-info/list")
    Response<List<ActivityZhWashCarReceiveInfo>> listActivityZhWashCarReceiveInfo(@RequestParam("userCode") String userCode,
                                                                                  @RequestParam("activityCodeList") List<String> activityCodeList,
                                                                                  @RequestParam("couponCodeList") List<String> couponCodeList);

    /**
     * Count user receive coupon num response.
     *
     * @param userCode           the user code
     * @param couponCode         the coupon code
     * @param activityCode       the activity code
     * @param licensePlateNumber the license plate number
     * @param startTime          the start time
     * @param endTime            the end time
     * @return the response
     */
    @GetMapping("/api/activity/activity-zh-wash-car-receive-info/count")
    Response<Integer> countActivityZhWashCarReceiveInfo(@RequestParam(value = "userCode", required = false) String userCode,
                                                        @RequestParam(value = "couponCode", required = false) String couponCode,
                                                        @RequestParam(value = "activityCode", required = false) String activityCode,
                                                        @RequestParam(value = "licensePlateNumber", required = false) String licensePlateNumber,
                                                        @RequestParam(value = "startTime", required = false) String startTime,
                                                        @RequestParam(value = "endTime", required = false) String endTime);
    /*********************************************   ranxiangfu 珠海9块9洗车优惠券领取记录相关接口 end   ********************************************************************/

    /*********************   yinshihao 赠送活动基本信息接口 start   ******************************/
    /**
     * 根据赠送活动编码获取对应信息(包括赠送产品列表)
     *
     * @param activityCode
     * @return
     */
    @GetMapping("/api/send/activity/main/info/getAllByActivityCode")
    Response<ActivitySendMainInfo> getAllByActivityCode(@RequestParam(value = "activityCode") String activityCode);

    /**
     * 根据投放平台miniAppid获取赠送活动列表(前端用)
     *
     * @param putPlatformMiniAppid
     * @return
     */
    @GetMapping("/api/send/activity/main/info/getSendActivityListByMiniAppid")
    Response<List<ActivitySendMainInfo>> getSendActivityListByMiniAppid(@RequestParam(value = "putPlatformMiniAppid") String putPlatformMiniAppid,
                                                                        @RequestParam(value = "status", required = false) String status);

    /**
     * 查询积分兑换油卡赠送产品活动信息列表
     *
     * @param searchDto
     * @return
     */
    @PostMapping("/api/send/activity/main/info/list")
    PageTable<ActivitySendMainInfo> findActivitySendMainInfoList(@RequestBody ActivitySendMainInfoSearchDto searchDto);

    /**
     * 根据编号查看积分兑换油卡赠送产品活动信息详情
     *
     * @param code
     * @return
     */
    @GetMapping("/api/send/activity/main/info/detail/{code}")
    Response<ActivitySendMainInfo> findActivitySendMainInfoByCode(@PathVariable("code") String code);

    /**
     * 根据id更新积分兑换油卡赠送产品活动上架状态
     *
     * @param changeStatusDto
     * @return
     */
    @PostMapping("/api/send/activity/main/info/changeStatus")
    Response changeActivitySendMainInfoStatusById(@RequestBody ActivitySendMainInfoChangeStatusDto changeStatusDto);

    /**
     * 根据活动编码删除活动
     *
     * @param code 活动编码
     * @return
     */
    @GetMapping("/api/send/activity/main/info/deleteSendActivityByActivityCode")
    Response deleteSendActivityByActivityCode(@RequestParam("code") String code);
    /*********************   yinshihao 赠送活动基本信息接口 end   *******************************/

    /*********************   yinshihao 活动参与记录 start   ******************************/
    /**
     * 验证订单+状态是否已经存在
     *
     * @param orderCode  订单编号
     * @param statusType 状态类型
     * @return true: 存在, false:不存在
     */
    @GetMapping("/api/send/activity/join/log/checkOrderIsExistByOrderCode")
    Response<Boolean> checkOrderIsExistByOrderCode(@RequestParam(value = "orderCode") String orderCode,
                                                   @RequestParam(value = "statusType") String statusType);

    /**
     * 更新或保存赠送活动参与记录
     *
     * @param activitySendJoinLog
     * @return
     */
    @PostMapping("/api/send/activity/join/log/saveOrUpdateActivitySendJoinLog")
    Response<String> saveOrUpdateActivitySendJoinLog(@RequestBody ActivitySendJoinLog activitySendJoinLog);

    /**
     * 修改状态
     *
     * @param code
     * @param status
     * @return
     */
    @GetMapping("/api/send/activity/join/log/updateJoinLogStatus")
    Response updateJoinLogStatus(@RequestParam("code") String code, @RequestParam("status") String status);

    /**
     * 根据订单编号查询参与记录及其明细
     *
     * @param orderCode
     * @return
     */
    @GetMapping("/api/send/activity/join/log/getJoinLogByOrderCode")
    Response<ActivitySendJoinLog> getJoinLogByOrderCode(@RequestParam("orderCode") String orderCode);

    /**
     * 分页查询活动参与记录
     *
     * @param req
     * @return
     */
    @PostMapping("/api/send/activity/join/log/page")
    PageTable<SendActivityJoinLogListResp> pageActivitySendJoinLog(@RequestBody SendActivityJoinLogSearchReq req);

    /**
     * 不分页查询活动参与记录
     *
     * @param req
     * @return
     */
    @PostMapping("/api/send/activity/join/log/list")
    Response<List<SendActivityJoinLogListResp>> listActivitySendJoinLog(@RequestBody SendActivityJoinLogSearchReq req);

    /**
     * 根据参与记录编号获取参与记录及其明细和活动相关信息(详情页使用)
     *
     * @param joinLogCode
     * @return
     */
    @GetMapping("/api/send/activity/join/log/getJoinLogAllInfoByJoinLogCode")
    Response<ActivitySendJoinLog> getJoinLogAllInfoByJoinLogCode(@RequestParam("joinLogCode") String joinLogCode);
    /*********************   yinshihao 活动参与记录 end   *******************************/

    /*********************   yinshihao 赠送活动参与明细 start   ******************************/
    /**
     * 更新或保存赠送活动参与明细
     *
     * @param activitySendJoinDetail
     * @return
     */
    @PostMapping("/api/send/activity/join/detail/saveOrUpdateActivitySendJoinDetail")
    Response<String> saveOrUpdateActivitySendJoinDetail(@RequestBody ActivitySendJoinDetail activitySendJoinDetail);

    /**
     * 修改状态
     *
     * @param code
     * @param status
     * @return
     */
    @GetMapping("/api/send/activity/join/detail/updateStatus")
    Response updateStatus(@RequestParam("code") String code, @RequestParam("status") String status);


    /**
     * 新增
     *
     * @param req
     * @return
     */
    @PostMapping("/api/send/activity/main/info/create")
    Response createSendActivity(@RequestBody SendActivityCreateReq req);

    /**
     * 编辑
     *
     * @param req
     * @return
     */
    @PostMapping("/api/send/activity/main/info/edit")
    Response editSendActivity(@RequestBody SendActivityEditReq req);


    /**
     * 获取活动的最大顺序号
     *
     * @param putPlatformCode 投放平台编号
     * @return
     */
    @GetMapping("/api/send/activity/main/info/getActivityMaxSort/{code}")
    Response<Integer> getSendActivityMaxSort(@PathVariable("code") String putPlatformCode);

    /**
     * 保存错误信息
     *
     * @param code
     * @param errorMsg
     * @return
     */
    @GetMapping("/api/send/activity/join/detail/addErrorMsg")
    Response addErrorMsg(@RequestParam("code") String code, @RequestParam("errorMsg") String errorMsg,
                         @RequestParam(value = "status", required = false) String status);
    /*********************   yinshihao 赠送活动参与明细 end   *******************************/

    /*********************   yinshihao 赠送活动产品 start   *******************************/
    /**
     * 根据赠送活动编码获取赠送产品列表
     *
     * @param activityCode
     * @return
     */
    @GetMapping("/api/send/activity/goods/info/getByActivityCode")
    Response<List<ActivitySendGoodsInfo>> getByActivityCode(@RequestParam(value = "activityCode") String activityCode);
    /*********************   yinshihao 赠送活动产品 end   *******************************/

    /************************************ 权益线上领取活动 start   ****************************/

    /**
     * 不分页查询领取记录
     *
     * @param req
     * @return
     */
    @GetMapping("/api/activity/reo/receive/record/listRecord")
    Response<List<ActivityReoReceiveRecord>> listReoReceiveRecord(@SpringQueryMap ReoReceiveRecordSearchReq req);

    /**
     * 根据领取记录编码查询领取记录及明细
     *
     * @param recordCode the record code
     * @return reo receive record with item by code
     */
    @GetMapping("/api/activity/reo/receive/record/getRecordWithItemByCode")
    Response<ActivityReoReceiveRecord> getReoReceiveRecordWithItemByCode(@RequestParam("recordCode") String recordCode);

    /**
     * 根据领取记录编号更新领券记录
     *
     * @param req
     * @return
     */
    @PostMapping("/api/activity/reo/receive/record/updateByRecordCode")
    Response updateReoRecordByRecordCode(@RequestBody RecordUpdateReq req);

    /**
     * 查询领取记录详情
     *
     * @param recordCode
     * @param includeItem 是否包括领取明细
     * @return
     */
    @GetMapping("/api/activity/reo/receive/record/detail")
    Response<ActivityReoReceiveRecord> reoReceiveRecordDetail(@RequestParam("recordCode") String recordCode,
                                                              @RequestParam("includeItem") boolean includeItem);

    /**
     * 后台管理查询活动领取记录
     *
     * @param req
     * @return
     */
    @PostMapping("/api/activity/reo/receive/record/page")
    PageTable<ReoReceiveRecordListResp> pageReoReceiveRecord(@RequestBody ReoReceiveRecordSearchReq req);

    /**
     * 根据领取记录编号查询领取记录明细
     *
     * @param recordCode 领取记录编号
     * @return
     */
    @GetMapping("/api/activity/reo/receive/record/item/listByRecordCode")
    Response<List<ActivityReoReceiveRecordItem>> listReoReceiveItemByRecordCode(@RequestParam("recordCode") String recordCode);

    /**
     * 新增或更新领取记录明细
     *
     * @param req
     * @return
     */
    @PostMapping("/api/activity/reo/receive/record/item/updateByItemCode")
    Response updateReoReceiveRecordItemByItemCode(@RequestBody ReoReceiveRecordUpdateReq req);

    /**
     * 根据投放平台miniAppid获取权益线上领取活动列表(小程序端用)
     *
     * @param launchPlatformMiniAppid
     * @param status
     * @return
     */
    @GetMapping("/api/activity/reo/activity-reo-info/getReoActivityListByMiniAppid")
    Response<List<ActivityReoInfo>> getReoActivityListByMiniAppid(@RequestParam(value = "launchPlatformMiniAppid", required = true) String launchPlatformMiniAppid,
                                                                  @RequestParam(value = "status", defaultValue = "OPEN", required = false) String status);

    /**
     * 根据权益线上领取活动code获取对应的活动详情(小程序端用)
     *
     * @param code
     * @return
     */
    @GetMapping("/api/activity/reo/activity-reo-info/getReoActivityDetail/{code}")
    Response<ActivityReoInfo> getReoActivityDetailByCode(@PathVariable(name = "code") String code);


    /**
     * 根据活动编号列表 查询活动列表（只返回活动主信息）
     */
    @PostMapping("/api/activity/reo/activity-reo-info/findActivityListByCodeIn")
    Response<List<ActivityReoInfo>> findActivityListByCodesIn(@RequestBody List<String> codeList);

    /**
     * 按照活动类型统计活动数量（包括全部状态）
     *
     * @param activityType
     */
    @GetMapping("/api/activity/reo/activity-reo-info/countActivityByType")
    Response<Integer> countActivityByType(@RequestParam("activityType") String activityType, @RequestParam(value = "miniAppId",required = false) String miniAppId);


    /**
     * 根据条件分页查询活动信息列表
     *
     * @param searchDto
     * @return
     */
    @PostMapping("/api/activity/reo/activity-reo-info/list")
    PageTable<ActivityReoInfo> queryActivityReoList(@RequestBody ReoInfoSearchDto searchDto);

    /**
     * 分页查询活动下的每日发放规则配置
     *
     * @param activityCode 活动编号
     * @param limit
     * @param page
     */
    @GetMapping("/api/activity/reo/activity-reo-info/findPerDayGrantRulePage")
    PageTable<SiginActPerDayGrantRuleConfig> findActivityPerDayGrantRulePage(@RequestParam("activityCode") String activityCode,
                                                                             @RequestParam(value = "limit", defaultValue = "20") int limit,
                                                                             @RequestParam(value = "page", defaultValue = "1") int page);

    /**
     * 更新活动每日发放规则
     *
     * @param perdayGrantRule
     */
    @PostMapping("/api/activity/reo/activity-reo-info/updatePerDayGrantRule")
    Response updateActivityPerDayGrantRule(@RequestBody SiginActPerDayGrantRuleConfig perdayGrantRule);

    /**
     * 获得活动某个发放日期的版本历史记录,从 新到旧 排序
     *
     * @param activityCode 活动编号
     * @param grantDate    发放日期
     */
    @GetMapping("/api/activity/reo/activity-reo-info/findGrantRuleVersionList")
    Response<List<SiginActPerDayGrantRuleConfig>> findActivityGrantRuleVersionList(@RequestParam("activityCode") String activityCode,
                                                                                   @RequestParam("grantDate") String grantDate);

    /**
     * 根据code查询活动详情信息
     *
     * @param code
     * @return
     */
    @GetMapping("/api/activity/reo/activity-reo-info/detail/{code}")
    Response<ActivityReoInfo> getActivityReoDetailByCode(@PathVariable("code") String code);

    /**
     * 根据投放平台code或者发放主体code查询对应的活动code列表
     *
     * @param launchPlatformMiniAppids
     * @param issuingBodyCodes
     * @return
     */
    @GetMapping("/api/activity/reo/activity-reo-info/queryCodes")
    Response<List<String>> queryActivityReoCodes(@RequestParam(name = "launchPlatformMiniAppids", required = false) String launchPlatformMiniAppids,
                                                 @RequestParam(name = "issuingBodyCodes", required = false) String issuingBodyCodes,
                                                 @RequestParam(name = "isIntersect", defaultValue = "false") Boolean isIntersect);

    /**
     * 新增或编辑权益线上领取活动
     *
     * @param addOrUpdateReqDto
     * @return
     */
    @PostMapping("/api/activity/reo/activity-reo-info/addOrUpdate")
    Response addOrEditActivityReo(@RequestBody ReoInfoAddOrUpdateReqDto addOrUpdateReqDto);

    /**
     * 根据code更新权益线上领取活动上架状态
     *
     * @param changeStatusReqDto
     * @return
     */
    @PostMapping("/api/activity/reo/activity-reo-info/changeStatus")
    Response changeActivityReoStatusByCode(@RequestBody ReoInfoAddOrUpdateReqDto changeStatusReqDto);

    /**
     * 根据活动编码删除权益线上领取活动
     *
     * @param code 活动编码
     * @return
     */
    @PostMapping("/api/activity/reo/activity-reo-info/delActivityReoCode/{code}")
    Response deleteActivityReoByCode(@PathVariable(name = "code") String code);



    // ================ 四川中银保员工内部活动 start ====


    // ======== 参与记录 start ====

    /**
     * 四川中银保员工内部活动 参加活动
     */
    @PostMapping("/api/activity/receiveAudit/joinRecord/join")
    Response<ActivityReceiveAuditJoinRecord> joinReceiveAuditActivity(@RequestBody ActivityReceiveAuditJoinRecord joinRecord);


    /**
     * 四川中银保员工内部活动 更新活动参与记录 (审核不通过后，修改参与记录，再次提交）
     */
    @PostMapping("/api/activity/receiveAudit/joinRecord/update")
    Response<ActivityReceiveAuditJoinRecord> updateReceiveAuditJoinRecord(@RequestBody ActivityReceiveAuditJoinRecord joinRecord);

    /**
     * 四川中银保员工内部活动 更新参与记录的基本信息，例如：供应链下游订单号
     */
    @PostMapping("/api/activity/receiveAudit/joinRecord/updateBasic")
    Response<ActivityReceiveAuditJoinRecord> updateReceiveAuditBasicJoinRecord(@RequestBody ActivityReceiveAuditJoinRecord joinRecord);



    /**
     * 四川中银保员工内部活动 获取活动参与记录列表
     */
    @GetMapping("/api/activity/receiveAudit/joinRecord/findList")
    Response<List<ActivityReceiveAuditJoinRecord>> findReceiveAuditJoinRecordList(@RequestParam("activityCode") String activityCode,
                                                                                  @RequestParam("joinerOpenId") String joinerOpenId,
                                                                                  @RequestParam("joinerMobile") String joinerMobile);


    /**
     * 四川中银保员工内部活动 获取活动参与记录
     * @param isLoadDetail 是否加载详情(审核记录列表、活动信息）
     */
    @GetMapping("/api/activity/receiveAudit/joinRecord/getByJoinCode")
    Response<ActivityReceiveAuditJoinRecord> getReceiveAuditJoinRecordByCode(@RequestParam("joinCode") String joinCode,
                                                                 @RequestParam(value = "isLoadDetail",defaultValue = "false") Boolean isLoadDetail);


    /**
     * 获取用户手机在某年的参与记录
     */
    @GetMapping("/api/activity/receiveAudit/joinRecord/getByYearAndMobile")
    Response<ActivityReceiveAuditJoinRecord> getReceiveActJoinRecordByYearAndMobile(@RequestParam("activityCode") String activityCode,
                                                                                    @RequestParam("joinYear") Integer joinYear,
                                                                                    @RequestParam("joinerMobile") String joinerMobile);


    /**
     * 参与记录审核通过后, 客户在车主端 选择礼品 (参数：joinCode, customerProductCode)
     */
    @PostMapping("/api/activity/receiveAudit/joinRecord/selectGiftWhenAuditPass")
    Response<ActivityReceiveAuditJoinRecord> selectGiftWhenAuditPass(@RequestBody ActivityReceiveAuditJoinRecordGift gift);


    /**
     * 只是获取活动的参与记录数量
     * 场景：admin编辑活动时 有记录不能修改产品
     * @param activityCode
     * @return
     */
    @GetMapping("/api/activity/receiveAudit/joinRecord/getReceiveAuditActCountJoinNum")
    Response<Integer> getReceiveAuditActCountJoinNum(@RequestParam("activityCode") String activityCode);


    /**
     * 分页搜索
     * 场景1:
     * admin的分页搜索
     * @param searchDto
     * @return
     */
    @PostMapping("/api/activity/receiveAudit/joinRecord/pageSearch")
    PageTable<ActivityReceiveAuditJoinRecord> receiveAuditActJoinRecordPageSearch(@RequestBody ReoReceiveAuditJoinRecordPageSearchDto searchDto);


    /**
     * 定时任务查找需要自动审核的 参与记录,按照参与时间升序排列 （任务每隔5分钟执行1次）
     * @return
     */
    @GetMapping("/api/activity/receiveAudit/joinRecord/scheduleFindAutoAuditJoinRecords")
    Response<List<ActivityReceiveAuditJoinRecord>> scheduleFindAutoAuditJoinRecords(@RequestParam(value = "fetchSize",defaultValue = "100") Integer fetchSize);


    /**
     * 查找有礼品发放失败的的参与记录，并重试发放礼品
     * @param fetchSize 每次获取发放失败礼品数量
     * @param minGiftId 礼品id
     * @return
     */
    @GetMapping("/api/activity/receiveAudit/joinRecord/scheduleFindFailedScmOrderJoinRecords")
    Response<List<ActivityReceiveAuditJoinRecord>> scheduleFindFailedScmOrderJoinRecords(@RequestParam(value = "fetchSize", defaultValue = "100") Integer fetchSize,
                                                                                         @RequestParam(value = "minGiftId", required = false) Integer minGiftId);

    //======== 参与记录 end ====



    // ==== 审核参与记录 start =====

    /**
     * 审核参与记录,保存审核记录后,返回审核后的参与记录信息（包括活动和礼品）
     */
    @PostMapping("/api/activity/receiveAudit/auditRecord/audit")
    Response<ActivityReceiveAuditJoinRecord> auditReceiveActJoinRecord(@RequestBody ActivityReceiveAuditRecord auditRecord);


    /**
     * 查看审核记录的审核内容
     */
    @GetMapping("/api/activity/receiveAudit/auditRecord/getAuditContent")
    Response<ActivityReceiveAuditContent> getReceiveJoinRecordAuditContent(@RequestParam("auditRecordId") Integer auditRecordId);


    // ==== 审核参与记录 end =====



    // ==== 参与记录礼品 start =====

    /**
     * 参与记录礼品调用供应链订单下单接口后，更新礼品的供应链订单状态
     */
    @PostMapping("/api/activity/receiveAudit/joinRecordGift/updateScmOrderInfo")
    Response updateReceiveJoinRecordGiftScmOrder(@RequestBody ActivityReceiveAuditJoinRecordGift joinRecordGift);

    // ==== 参与记录礼品 end =====


    // ================ 四川中银保员工内部活动 end ====


    /**
     * 根据条件分页查询活动礼包信息列表
     *
     * @param searchDto
     * @return
     */
    @GetMapping("/api/activity/reo/activity-reo-gift-info/list")
    PageTable<ActivityReoGiftInfo> queryReoGiftInfoList(@SpringQueryMap ReoGiftInfoSearchDto searchDto);

    /**
     * 根据code查询活动礼包详情信息
     *
     * @param code
     * @return
     */
    @GetMapping("/api/activity/reo/activity-reo-gift-info/detail/{code}")
    Response<ActivityReoGiftInfoDetailRespDto> getReoGiftInfoDetailByCode(@PathVariable("code") String code);

    /**
     * 新增或编辑
     *
     * @param addOrUpdateReqDto
     * @return
     */
    @PostMapping("/api/activity/reo/activity-reo-gift-info/addOrUpdate")
    Response addOrEditReoGiftInfo(@RequestBody ReoGiftInfoAddOrUpdateReqDto addOrUpdateReqDto);

    /**
     * 根据code更新权益线上领取活动礼包状态
     *
     * @param reoGiftInfo
     * @return
     */
    @PostMapping("/api/activity/reo/activity-reo-gift-info/changeStatus")
    Response changeReoGiftInfoStatusByCode(@RequestBody ActivityReoGiftInfo reoGiftInfo);


    /**
     * Reo gift receive response.
     *
     * @param req the req
     * @return the response
     */
    @PostMapping("/api/activity/reo/activity-reo-info/receive")
    Response<ReoGiftReceiveRes> reoGiftReceive(@RequestBody ReoGiftReceiveReq req);

    /**
     * 分页查询reo活动相关操作日志
     *
     * @param identifyCode
     * @param page
     * @param limit
     * @return
     */
    @GetMapping("/api/activity/reo/operationLog/page")
    PageTable<ActivityReoOperationLog> queryReoActivityOperationLogList(@RequestParam("identifyCode") String identifyCode, @RequestParam("page") Integer page, @RequestParam("limit") Integer limit);

    /**
     * Delete reo receiver info response.
     *
     * @param id the id
     * @return the response
     */
    @DeleteMapping("/api/activity/reo/receiverInfo/{id}")
    Response deleteReoReceiverInfo(@PathVariable("id") Integer id);

    /**
     * Batch save reo receiver info response.
     *
     * @param receiverInfoList the receiver info list
     * @return the response
     */
    @PostMapping("/api/activity/reo/receiverInfo/batchSave")
    Response<List<ActivityReoReceiverInfo>> batchSaveReoReceiverInfo(@RequestBody List<ActivityReoReceiverInfo> receiverInfoList);

    /**
     * Save or update reo receiver info response.
     *
     * @param receiverInfo the receiver info
     * @return the response
     */
    @PostMapping("/api/activity/reo/receiverInfo/saveOrUpdate")
    Response saveOrUpdateReoReceiverInfo(@RequestBody ActivityReoReceiverInfo receiverInfo);

    /**
     * Page query reo receiver info page table.
     *
     * @param receiverInfoPageQuery the receiver info page query
     * @return the page table
     */
    @GetMapping("/api/activity/reo/receiverInfo/pageQuery")
    PageTable<ActivityReoReceiverInfo> pageQueryReoReceiverInfo(
            @SpringQueryMap ActivityReoReceiverInfoPageQuery receiverInfoPageQuery);

    /************************************ 权益线上领取活动 end   ****************************/

    /************************************ 客户邀约到店登记管理 start   ****************************/
    /**
     * 更新或保存客户邀约到店登记管理
     *
     * @param management
     * @return
     */
    @PostMapping("/api/invite/management/saveOrUpdateInviteRegistrationManagement")
    Response<String> saveOrUpdateInviteRegistrationManagement(@RequestBody ActivityInviteRegistrationManagement management);

    /**
     * 根据邀约编号查询客户邀约到店登记管理
     *
     * @param code
     * @return
     */
    @GetMapping("/api/invite/management/getInviteRegistrationManagementByCode")
    Response<ActivityInviteRegistrationManagement> getInviteRegistrationManagementByCode(@RequestParam("code") String code);

    /**
     * 分页查询客户邀约到店登记管理
     *
     * @param queryDto
     * @return
     */
    @PostMapping("/api/invite/management/pageQueryInviteRegistrationManagement")
    PageTable<ActivityInviteRegistrationManagement> pageQueryInviteRegistrationManagement(@RequestBody InviteRegistrationManagementPageQueryDto queryDto);


    /**
     * 根据邀约编号删除客户邀约到店登记管理
     *
     * @param code 邀约编号
     * @return
     */
    @GetMapping("/api/invite/management/deleteInviteRegistrationManagementByCode")
    Response deleteInviteRegistrationManagementByCode(@RequestParam("code") String code);

    /**
     * 得到客户邀约到店登记的总记录数
     *
     * @param queryDto 查询请求
     * @return
     */
    @PostMapping("/api/invite/management/getInviteRegistrationManagementTotalCount")
    Response<Integer> getInviteRegistrationManagementTotalCount(@RequestBody InviteRegistrationManagementPageQueryDto queryDto);

    /**
     * 根据客户手机号和活动编号获取邀约到店登记信息
     *
     * @param customerPhone
     * @param activityCode
     * @return
     */
    @GetMapping("/api/invite/management/getManagementByCustomerPhoneAndActivityCode")
    Response<ActivityInviteRegistrationManagement> getManagementByCustomerPhoneAndActivityCode(@RequestParam("customerPhone") String customerPhone,
                                                                                               @RequestParam("activityCode") String activityCode,
                                                                                               @RequestParam("appointmentArrivalDate") String appointmentArrivalDate);
    /**
     * 根据发放主体编号和预约到店日期获取邀约到店登记信息
     *
     * @param issuingBodyCode
     * @param appointmentArrivalDate
     * @return
     */
    @GetMapping("/api/invite/management/findManagementListByIssuingBodyCodeAndDate")
    Response<List<ActivityInviteRegistrationManagement>> findManagementListByIssuingBodyCodeAndDate(@RequestParam("issuingBodyCode") String issuingBodyCode, @RequestParam("appointmentArrivalDate") String appointmentArrivalDate);

    /**
     * 批量保存客户邀约到店登记管理
     * @param managementList
     * @return
     */
    @PostMapping("/api/invite/management/batchSaveManagement")
    Response<Integer> batchSaveManagement(@RequestBody List<ActivityInviteRegistrationManagement> managementList);

    /************************************ 客户邀约到店登记管理 end   ****************************/

    /**
     * 保存签到参与记录
     *
     * @param signJoinLog
     * @return
     */
    @PostMapping("/api/activity/sign/activity-sign-join-log/saveOrUpdate")
    Response saveOrUpdateSignJoinLog(@RequestBody ActivitySignJoinLog signJoinLog);

    /**
     * 查找最近签到成功记录，只为C端提供，写死提供前20条数据
     */
    @GetMapping("/api/activity/sign/activity-sign-join-log/queryLatelySuccess")
    Response<List<ActivitySignJoinLog>> queryLatelySuccess(@RequestParam("activityCode") String activityCode);

    /**
     * 查询用户是否参与
     */
    @GetMapping("/api/activity/sign/activity-sign-join-log/queryByOpenIdAndMobile")
    Response<ActivitySignJoinLog> queryByOpenIdAndMobile(@RequestParam("activityCode") String activityCode,
                                                         @RequestParam("openId") String openId,
                                                         @RequestParam("mobile") String mobile);

    /**
     * 定时任务用，查询MQ发送失败的记录
     */
    @GetMapping("/api/activity/sign/activity-sign-join-log/queryFailMQ")
    Response<List<ActivitySignJoinLog>> queryFailMQ();

    /**
     * 根据活动编号和手机号 更新申请单号 以及错误信息
     *
     * @param signLogReq
     * @return
     */
    @PostMapping("/api/activity/sign/activity-sign-join-log/updateApplyNoAndErrorMsgByActivityCodeAndMobile")
    Response updateApplyNoAndErrorMsgByActivityCodeAndMobile(@RequestBody SignLogReq signLogReq);


    /**
     * 批量保存快照
     *
     * @param giftSnapshotList
     * @return
     */
    @PostMapping("/api/activity/sign/activity-sign-gift-snapshot/batchSave")
    Response batchSaveActivitySignGiftSnapshot(@RequestBody List<ActivitySignGiftSnapshot> giftSnapshotList);

    /**
     * 根据快照单号 查找礼品
     *
     * @param code
     * @return
     */
    @GetMapping("/api/activity/sign/activity-sign-gift-snapshot/querySnapshotByCode")
    Response<List<ActivitySignGiftSnapshot>> querySnapshotByCode(@RequestParam("code") String code);

    /**
     * 签到记录列表
     *
     * @param searchDto
     * @return
     */
    @PostMapping("/api/activity/sign/activity-sign-join-log/list")
    PageTable<ActivitySignJoinLog> querySignLogList(@RequestBody SignLogSearchDto searchDto);

    @GetMapping("/api/activity/sign/activity-sign-join-log/getSignLogByCode")
    Response<ActivitySignJoinLog> getSignLogByCode(@RequestParam("code") String code);

    /**
     * 签到记录列表不分页
     * @param searchDto
     * @return
     */
    @PostMapping("/api/activity/sign/activity-sign-join-log/no-page")
    Response<List<ActivitySignJoinLog>> querySignLogListNoPage(@RequestBody SignLogSearchDto searchDto);

    @GetMapping("/api/activity/reo/activity-reo-info/get-group-detail-with-stage")
    Response<ActivityGroupActInfo> getGroupDetailWithStage(@RequestParam("activityCode") String activityCode);

    /**
     * 川分员工之家 领取验证活动配置的礼品,修改时是否允许提交礼品
     * （1）没有参与记录，肯定可以提交修改礼品
     * （2）如果有参与记录，但是礼品没有变化，则允许提交
     */
    @PostMapping("/api/activity/reo/activity-reo-info/validateAllowCommitGiftOnUpdate")
    Response<Boolean> validateReceiveAuditGiftAllowCommit(@RequestBody ActivityReceiveAuditConfig auditConfig);

    /**
     * 分页查询参团记录列表
     * @param params  入参实体
     * @return  参团记录列表
     */
    @PostMapping("/api/activity/group/participants/page")
    PageTable<ActivityGroupParticipants> groupActParticipantsPageSearch(@RequestBody ActivityGroupParticipantsQueryDto params);

    /**
     * 根据活动编码获取参团记录列表
     * @param activityCode  活动编码
     * @return  参团记录列表
     */
    @GetMapping("/api/activity/group/participants/listByActivityCode")
    Response<List<ActivityGroupParticipants>> listGroupActParticipantsByActivityCode(@RequestParam("activityCode") String activityCode);

    /**
     * 根据openId获取参团记录列表
     * @param openId  openId
     * @return  参团记录列表
     */
    @GetMapping("/api/activity/group/participants/listByOpenId")
    Response<List<ActivityGroupParticipants>> listGroupActParticipantsByOpenId(@RequestParam("activityCode") String activityCode, @RequestParam("openId") String openId);

    /**
     * 根据活动编码获取参团记录数量
     * @param activityCode  活动编码
     * @return  参团记录数量
     */
    @GetMapping("/api/activity/group/participants/countByActivityCode")
    Response<Integer> countGroupActParticipantsByActivityCode(@RequestParam("activityCode") String activityCode);

    /**
     * 根据活动编码获取参团记录
     * @param code      记录编码
     * @return  参团记录
     */
    @GetMapping("/api/activity/group/participants/getByCode")
    Response<ActivityGroupParticipants> getGroupActParticipantsByCode(@RequestParam("code") String code);

    /**
     * 更新或保存参团记录实体
     * @param data  实体对象
     */
    @PostMapping("/api/activity/group/participants/saveOrUpdate")
    Response<ActivityGroupParticipants> saveOrUpdateGroupActParticipants(@RequestBody ActivityGroupParticipants data);

    /**
     * 支付成功回调，在interface调用
     * @param data  实体对象，里面只需要传code
     */
    @PostMapping("/api/activity/group/participants/paySuccess")
    Response<?> groupActParticipantsPaySuccess(@RequestBody ActivityGroupParticipants data);

    /**
     * 获取参团人数、当前阶梯数据
     * @param activityCode      活动编码
     * @return  参团人数、当前阶梯数据DTO
     */
    @GetMapping("/api/activity/group/participants/getCurrentGroupActParticipants")
    Response<ActivityGroupParticipantsStageDto> getCurrentGroupActParticipants(@RequestParam("activityCode") String activityCode);


    /**
     * 只获取活动的最基础信息
     * 已知:生成菊花码使用
     */
    @GetMapping("/api/activity/reo/activity-reo-info/getReoActivityBaseDetail/{code}")
    Response<ActivityReoInfo> getReoActivityBaseDetailByCode(@PathVariable(name = "code") String code);

    /**
     * 只更新最基础的信息
     *  已知:更新菊花码使用
     * @return
     */
    @PostMapping("/api/activity/reo/activity-reo-info/updateReoActivityBaseInfo")
    Response updateReoActivityBaseInfo(@RequestBody ActivityReoInfo req);
}
