package com.rocogz.syy.activity.dto.reo.receiveAudit;

import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import lombok.Data;

import java.time.LocalDateTime;
import java.util.List;

/**
 * @Description: 领取审核活动的参与记录分页搜索请求
 * @date：2023/04/14
 * @author：huhailong
 */
@Data
public class ReoReceiveAuditJoinRecordPageSearchDto {

    /**
     * 参与人手机号  【模糊查询】
     */
    private String joinerMobile;

    /**
     * 参与人车牌号 【模糊查询】
     */
    private String joinerCarLicence;

    /**
     * 员工姓名 【模糊查询】
     */
    private String empName;

    /**
     * 所属机构 【模糊查询】
     */
    private String empOrgName;

    /**
     * 记录编号 精确查询
     */
    private String joinCode;

    /**
     * 活动编号 精确查询
     */
    private String activityCode;

    /**
     * 投放平台编码列表
     */
    private List<String> miniAppids;

    /**
     * 发放主体编码列表
     */
    private List<String> issuingBodyCodes;

    /**
     * 参与时间最小值
     */
    private String joinTimeMinTime;

    /**
     * 参与时间最大值
     */
    private String joinTimeMaxTime;

    /**
     * 审核时间最小值
     */
    private String auditTimeMinTime;

    /**
     * 审核时间最大值
     */
    private String auditTimeMaxTime;

    /**
     * 审核状态,待审核、审核通过、审核不通过
     * @see ActivityConstant.DictReceiveActivityJoinRecordAuditStatus#PENDING
     */
    private String auditStatus;


    /**
     * 是否已选择礼品 Y/N ,【如果领取规则是：多选一 有值】
     * @see ActivityConstant.DictData#COMMON_YES
     */
    private String giftSelected;

    /**
     * 当前页
     */
    private int page;

    /**
     * 每页记录数
     */
    private int limit;


    public String getLikeJoinMobile() {
        if(StringUtils.isBlank(joinerMobile)) {
            return null;
        }

        return "%" + joinerMobile.trim() + "%";
    }


    public String getLikeJoinerCarLicence() {
        if(StringUtils.isBlank(joinerCarLicence)) {
            return null;
        }

        return "%" + joinerCarLicence.trim() + "%";
    }

    public String getLikeEmpName() {
        if(StringUtils.isBlank(empName)) {
            return null;
        }

        return "%" + empName.trim() + "%";
    }


    public String getLikeEmpOrgName() {
        if(StringUtils.isBlank(empOrgName)) {
            return null;
        }

        return "%" + empOrgName.trim() + "%";
    }

}