package com.rocogz.syy.activity.entity.reo.receive;

import com.baomidou.mybatisplus.annotation.TableField;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.rocogz.syy.activity.constant.ActivityConstant;
import com.rocogz.syy.activity.entity.reo.ActivityReoInfo;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.*;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * <p>
 * 领取审核活动配置的赠送礼品（四川中银宝员工内部活动）
 * </p>
 *
 * @author zhangmin
 * @since 2023-04-12
 */
@JsonIgnoreProperties(ignoreUnknown = true)
@Setter @Getter
@Accessors(chain = true)
public class ActivityReceiveAuditGiftConfig extends ActivityReceiveBaseGift {

    /**
     * 活动编码
     *
     * @see ActivityReoInfo#code
     */
    private String activityCode;

    /**
     * 产品内容
     */
    private String content;

    /**
     * 赠送状态：启用(OPEN)/ 停用 (LOCK)
     * @see ActivityConstant.DictData#COMMON_STATUS_OPEN_CODE
     */
    private String givenStatus;


    /**
     * 管理后台 参与记录详情 显示是否已发放, Y/N
     * @see ActivityConstant.DictData#COMMON_YES
     */
    @TableField(exist = false)
    private String granted;

    /**
     * 管理后台 参与记录详情 显示 产品券发放时间
     */
    @TableField(exist = false)
    private LocalDateTime grantTime;



    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder();
        //格式化成保留三位小数,四舍五入 方便比较
        String faceValueStr = String.format("%.3f",getFaceValue());
        buf.append("customerProductCode=").append(getCustomerProductCode())
                .append("quantity=").append(getQuantity())
                .append("faceValue=").append(faceValueStr)
                .append("givenStatus=").append(givenStatus);
        return buf.toString();
    }

}
