package com.rocogz.syy.activity.entity.reo.receive;


import com.baomidou.mybatisplus.annotation.TableField;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.rocogz.syy.activity.entity.reo.ActivityReoInfo;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.time.LocalDateTime;
import java.util.List;

/**
 * 领取审核 活动参与记录审核的内容（四川中银保员工内部活动 ）
 * @author zhangmin
 */
@Setter @Getter
@NoArgsConstructor
@Accessors(chain = true)
@JsonIgnoreProperties(ignoreUnknown = true)
public class ActivityReceiveJoiner extends IdEntity {

    /**
     * 活动编码
     * @see  ActivityReoInfo#code
     */
    private String activityCode;

    /**
     * 活动参与记录编号
     */
    private String joinCode;

    /**
     * 参与人手机号
     */
    private String joinerMobile;

    /**
     * 参与人用户编号,即车主端会员编号
     */
    private String joinerCode;

    /**
     * 参与人openid
     */
    private String joinerOpenid;


    /**
     * 参与人车牌号
     */
    private String joinerCarLicence;


    /**
     * 参与人员工姓名
     */
    private String empName;

    /**
     * 参与人员工所属机构
     */
    private String empOrgName;

    /**
     * 员工证件img url
     */
    private String empIdcardImg;

    /**
     * 参与时间
     */
    private LocalDateTime joinTime;

    /**
     * 车险附件
     */
    @TableField(exist = false)
    private List<ActivityReceiveAuditAttach> attachList;
}
