package com.rocogz.syy.alipay.config;

import com.alipay.easysdk.factory.Factory;
import com.alipay.easysdk.kernel.Config;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;

import javax.annotation.PostConstruct;

/**
 * <dl>
 * <dd>Description: AlipayAutoConfiguration</dd>
 * <dd>Company: 大诚若谷信息技术有限公司</dd>
 * <dd>@date：2020/11/10 13:47</dd>
 * <dd>@author：ranxiangfu</dd>
 * </dl>
 */
@Slf4j
@Configuration
@EnableConfigurationProperties(AlipayProperties.class)
@ConditionalOnProperty(prefix = "alipay", value = "enabled", matchIfMissing = true)
public class AlipayAutoConfiguration {

    @Autowired
    private AlipayProperties properties;

    @PostConstruct
    private void setAlipayConfig() {
        if (StringUtils.isEmpty(properties.getAppId())) {
            return;
        }
        log.info("初始化支付宝支付配置信息开始");
        Config config = new Config();
        config.protocol = properties.protocol;
        config.gatewayHost = properties.gatewayHost;
        config.signType = properties.signType;

        config.appId = properties.appId;

        config.merchantPrivateKey = properties.merchantPrivateKey;

        // 证书文件路径支持设置为文件系统中的路径或CLASS_PATH中的路径，优先从文件系统中加载，加载失败后会继续尝试从CLASS_PATH中加载
        config.merchantCertPath = properties.merchantCertPath;
        config.alipayCertPath = properties.alipayCertPath;
        config.alipayRootCertPath = properties.alipayRootCertPath;

        //注：如果采用非证书模式，则无需赋值上面的三个证书路径，改为赋值如下的支付宝公钥字符串即可
        config.alipayPublicKey = properties.alipayPublicKey;

        // 可设置异步通知接收服务地址（可选）
        config.notifyUrl = properties.notifyUrl;

        // 可设置AES密钥，调用AES加解密相关接口时需要（可选）
        config.encryptKey = properties.encryptKey;

        Factory.setOptions(config);
        log.info("初始化支付宝支付配置信息结束");
    }
}
