package com.rocogz.syy.common.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.time.LocalDateTime;

/**
 * 添加用户时间
 * @author：liangyongtong
 * @since：2020/4/1
 */
public class UserTimeEntity extends IdEntity {
    /**
     * 创建的用户 username
     */
    private String createUser;

    /**
     * 创建账号
     */
    @TableField(exist = false)
    private Account createAccount;

    /**
     * 更新的用户 username
     */
    private String updateUser;

    /**
     * 更新账号
     */
    @TableField(exist = false)
    private Account updateAccount;

    /**
     * 创建时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+08:00")
    private LocalDateTime createTime;

    /**
     * 最后更新时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+08:00")
    private LocalDateTime updateTime;

    public String getCreateUser() {
        return createUser;
    }

    public void setCreateUser(String createUser) {
        this.createUser = createUser;
    }

    public Account getCreateAccount() {
        return createAccount;
    }

    public void setCreateAccount(Account createAccount) {
        this.createAccount = createAccount;
    }

    public String getUpdateUser() {
        return updateUser;
    }

    public void setUpdateUser(String updateUser) {
        this.updateUser = updateUser;
    }

    public Account getUpdateAccount() {
        return updateAccount;
    }

    public void setUpdateAccount(Account updateAccount) {
        this.updateAccount = updateAccount;
    }

    public LocalDateTime getCreateTime() {
        return createTime;
    }

    public void setCreateTime(LocalDateTime createTime) {
        this.createTime = createTime;
    }

    public LocalDateTime getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(LocalDateTime updateTime) {
        this.updateTime = updateTime;
    }
}
