package com.rocogz.syy.common;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;

/**
 * layui 表格需要数据格式
 *
 * @param <E>
 */
public class PageTable<E> implements Serializable {


    public static final PageTable EMPTY_PAGE = build(Collections.emptyList(), 0, 0, "");

    /**
     * 数据
     */
    private List<E> data;

    /**
     * 总条数
     */
    private long count;

    private int code;

    private String msg;

    /**
     * 无参构造方法
     */
    public PageTable() {
    }

    public PageTable(List<E> data, long count, int code, String msg) {
        this.data = data;
        this.count = count;
        this.code = code;
        this.msg = msg;
    }

    public static <E> PageTable<E> build(List<E> data, long count, int code, String msg) {
        return new PageTable<E>(data, count, code, msg);
    }

    public static <E> PageTable<E> build(List<E> data, long count) {
        return new PageTable<E>(data, count, 0, "成功");
    }

    public List<E> getData() {
        return data;
    }

    public void setData(List<E> data) {
        this.data = data;
    }

    public long getCount() {
        return count;
    }

    public void setCount(long count) {
        this.count = count;
    }

    public int getCode() {
        return code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public String getMsg() {
        return msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }
}
