package com.rocogz.syy.common.entity;

import com.fasterxml.jackson.annotation.JsonFormat;

import java.time.LocalDateTime;

/**
 * 版本信息
 * @author：liangyongtong
 * @since ：2020/1/14
 */
public class VersionEntity extends IdEntity {

    /**
     * 创建人id
     */
    protected Account createUser;
    /**
     * 创建时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+08:00")
    protected LocalDateTime createTime;

    /**
     * 最后更新用户
     */
    protected Account updateUser;

    /**
     * 最后更新时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+08:00")
    protected LocalDateTime updateTime;

    public Account getCreateUser() {
        return createUser;
    }

    public IdEntity setCreateUser(Account createUser) {
        this.createUser = createUser;
        return this;
    }

    public LocalDateTime getCreateTime() {
        return createTime;
    }

    public IdEntity setCreateTime(LocalDateTime createTime) {
        this.createTime = createTime;
        return this;
    }

    public Account getUpdateUser() {
        return updateUser;
    }

    public IdEntity setUpdateUser(Account updateUser) {
        this.updateUser = updateUser;
        return this;
    }

    public LocalDateTime getUpdateTime() {
        return updateTime;
    }

    public IdEntity setUpdateTime(LocalDateTime updateTime) {
        this.updateTime = updateTime;
        return this;
    }
}
