package com.rocogz.syy.charge.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.charge.constant.ChargeConstant;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.experimental.Accessors;

/**
 * @Description: C端充电流水表
 * @date：2023/02/27
 * @author：
 */
@Data
@Accessors(chain = true)
@TableName("charge_turnover")
public class ChargeTurnover extends IdEntity {

    private static final long serialVersionUID = 944413716275281345L;

    /**
    * 流水号
    */
    private String code;

    /**
     * 第三方流水号
     */
    private String serialNo;
    
    /**
    * 卡号
    */
    private String accountCode;
    
    /**
    * 订单编号
    */
    private String orderCode;

    /**
     * 业务单号
     */
    private String businessCode;

    /**
    * 类型（字典，字典编号：CHARGE_TURNOVER_TYPE）
     * @see ChargeConstant.TurnoverType
    */
    private String turnoverType;
    
    /**
    * 变更前余额
    */
    private BigDecimal quotaBeforeChange;
    
    /**
    * 变更余额
    */
    private BigDecimal quotaChange;
    
    /**
    * 变更后余额
    */
    private BigDecimal quotaAfterChange;
    
    /**
    * 下单时间
    */
    private LocalDateTime orderTime;

    /**
     * 充电开始时间
     */
    private LocalDateTime chargeStartTime;

    /**
     * 充电结束时间
     */
    private LocalDateTime chargeEndTime;
    
    /**
    * 结算时间
    */
    private LocalDateTime settleTime;
    
    /**
    * 请求标志位
    */
    private String requestFlag;
    
    /**
    * 三方平台订单类型
    */
    private String thirdPlatformOrderType;
    
    /**
    * 三方平台订单编号
    */
    private String thirdPlatformOrderCode;

    /**
     * 来源小程序miniAppId
     */
    private String miniAppId;
    
    /**
    * 来源平台
    */
    private String sourcePlatform;

    /**
     * 来源平台名称
     */
    @TableField(exist = false)
    private String sourcePlatformName;

    /**
    * 创建人
    */
    private String createUser;
    
    /**
    * 创建时间
    */
    private LocalDateTime createTime;
}