package com.rocogz.syy.charge.client;

import com.rocogz.syy.charge.dto.TurnoverSearchDto;
import com.rocogz.syy.charge.entity.ChargeAccount;
import com.rocogz.syy.charge.entity.ChargeDetail;
import com.rocogz.syy.charge.entity.ChargeTurnover;
import com.rocogz.syy.common.PageTable;
import com.rocogz.syy.common.response.Response;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * The interface Charge c client service.
 */
public interface IChargeCClientService {

    /**
     * 根据手机号和类型获取对应的账户信息
     * @param mobile
     * @param type
     * @return
     */
    @GetMapping("/api/charge/account/info")
    Response<ChargeAccount> getChargeAccount(@RequestParam String mobile, @RequestParam String type);

    /**
     * 新增或更新账户信息
     * @param account
     * @return
     */
    @PostMapping("/api/charge/account/addOrUpdate")
    Response addOrUpdateChargeAccount(@RequestBody ChargeAccount account);

    /**
     * 根据条件分页查询流水
     * @param searchDto
     * @return
     */
    @GetMapping("/api/charge/turnover/list")
    PageTable<ChargeTurnover> selectChargeTurnoverList(TurnoverSearchDto searchDto);

    /**
     * 新增流水
     * @param turnover
     * @return
     */
    @PostMapping("/api/charge/turnover/add")
    Response addChargeTurnover(@RequestBody ChargeTurnover turnover);

    /**
     * 根据流水号查询对应的明细
     * @param turnoverCode
     * @return
     */
    @GetMapping("/api/charge/detail/getByTurnoverCode")
    Response<List<ChargeDetail>> selectChargeDetailByTurnoverCode(@RequestParam String turnoverCode);
}
