package com.rocogz.syy.charge.constant;

/**
 * C端充电基础服务，常量类
 * @author zhangmin
 * @date 2020/4/3
 */
public class ChargeConstant {
    public static final String YYYY_MM_DD_HH_MM_SS = "yyyy-MM-dd HH:mm:ss";
    public static final String YYYY_MM_DD = "yyyy-MM-dd";
    public static final String TIME_ZONE = "GMT+08:00";
    public static final String MIN_TIME_SUFFIX = " 00:00:01";
    public static final String MAX_TIME_SUFFIX = " 23:59:59";

    /**
     * 用户卡号
     */
    public static final String SOUTHERN_CHARGE_CODE = "SOUTHERN_CHARGE_CODE";

    /**
     * 流水号
     */
    public static final String SOUTHERN_CHARGE_SERIAL = "SOUTHERN_CHARGE_SERIAL";

    /**
     * 运营中心基础微服务名称
     */
    public static final String APPLICATION_NAME = "charge-c-service";

    public static class DataStatus {
        /** status 启用状态 */
        public static final String NORMAL = "OPEN";

        /** status 锁定状态 */
        public static final String LOCK = "LOCK";
    }

    /**
     * 发号键值
     */
    public class SerialNo {

    }

    /**
     * 账户相关常量
     */
    public static class Account {

        /**
         * 账号类型type code
         */
        public static final String ACCOUNT_TYPE_CODE = "CHARGE_ACCOUNT_TYPE";

        /**
         * 账号类型-南网电动
         */
        public static final String SOUTHERN = "SOUTHERN";
    }

    /**
     * 流水相关常量
     */
    public static class Turnover {
        /**
         * 流水类型type code
         */
        public static final String TURNOVER_TYPE_CODE = "CHARGE_TURNOVER_TYPE";

        /**
         * 流水类型-积分充值电卡
         */
        public static final String TURNOVER_TYPE_POINT_TO_ELECTRIC_CARD = "POINT_TO_ELECTRIC_CARD";

        /**
         * 流水类型-【充值卡-充电】消费
         */
        public static final String TURNOVER_TYPE_COMSUME = "COMSUME";

        /**
         * 流水类型-顺易充电卡
         */
        public static final String TURNOVER_TYPE_PROVIDE_ELECTRIC_CARD = "PROVIDE_ELECTRIC_CARD";

        /**
         * 流水类型-补收
         */
        public static final String TURNOVER_TYPE_REOBTAIN = "REOBTAIN";

        /**
         * 流水类型-退款
         */
        public static final String TURNOVER_TYPE_ORDER_REFUND = "ORDER_REFUND";

        /**
         * 流水类型-后台取消
         */
        public static final String TURNOVER_TYPE_BACKEND_CANCEL = "BACKEND_CANCEL";
    }
}
