package com.rocogz.syy.charge.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.experimental.Accessors;

/**
 * @Description: C端充电明细表
 * @date：2023/02/27
 * @author：
 */
@Data
@Accessors(chain = true)
@TableName("charge_detail")
public class ChargeDetail extends IdEntity {

    private static final long serialVersionUID = 710576143185164474L;

    /**
    * 明细编号
    */
    private String code;
    
    /**
    * 流水号
    */
    private String turnoverCode;
    
    /**
    * 卡号
    */
    private String accountCode;
    
    /**
    * 手机号
    */
    private String mobile;
    
    /**
    * 类型（积分、直发）
    */
    private String type;
    
    /**
    * 状态（待使用、已使用、已过期）
    */
    private String status;
    
    /**
    * 总额度
    */
    private BigDecimal totalQuota;
    
    /**
    * 可用额度
    */
    private BigDecimal availableQuota;
    
    /**
    * 已用额度
    */
    private BigDecimal usedQuota;
    
    /**
    * 生效日期
    */
    private LocalDateTime effctiveDate;
    
    /**
    * 失效日期
    */
    private LocalDateTime expireDate;
    
    /**
    * 来源平台
    */
    private String sourcePlatform;
}