package com.rocogz.syy.charge.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.experimental.Accessors;

/**
 * @Description: C端充电使用记录表
 * @date：2023/02/27
 * @author：
 */
@Data
@Accessors(chain = true)
@TableName("charge_use_record")
public class ChargeUseRecord extends IdEntity {

    private static final long serialVersionUID = 100368813498934390L;

    /**
    * 明细编号
    */
    private String detailCode;
    
    /**
    * 订单编号
    */
    private String orderCode;
    
    /**
    * 卡号
    */
    private String accountCode;
    
    /**
    * 使用额度
    */
    private BigDecimal useQuota;
    
    /**
    * 使用时间
    */
    private LocalDateTime useTime;

    /**
    * 备注
    */
    private String remark;
    
    /**
    * 删除标记（Y-已删除、N-未删除）
    */
    private String deleted;
}