package com.rocogz.syy.charge.constant;

import lombok.Getter;

import java.util.Arrays;
import java.util.Optional;

/**
 * 变动类型 03-订单消费，04-订单补收，05-订单退款
 */
public enum ChangeTypeEnum {

	Comsume("03", "订单消费"),

	Reobtain("04", "订单补收"),

	Refund("05", "订单退款");


	ChangeTypeEnum(String code, String label){
        this.code=code;
        this.label=label;
	}

	@Getter
	private String code;

	@Getter
	private String label;


	public static ChangeTypeEnum getByCode(String code){
		Optional<ChangeTypeEnum> optional = Arrays.stream(ChangeTypeEnum.values()).filter(item -> code.equals(item.getCode())).findFirst();
		return optional.orElse(null);
	}

}
