package com.rocogz.syy.charge.entity;


import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.charge.constant.ChargeConstant;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * @Description: C端充电客户流水表
 * @date：2023/02/27
 * @author：
 */
@Data
@Accessors(chain = true)
@TableName("customer_charge_turnover")
public class CustomerChargeTurnover extends IdEntity {

    /**
     * 流水号
     */
    private String code;


    /**
     * 卡号
     */
    private String accountCode;

    /**
     * 下游订单编号（客户订单编号）
     */
    private String orderCode;

    /**
     * 下单业务单号（即清单编号:接口发放/后台批量发放）
     */
    private String businessCode;

    /**
     * 类型（字典，字典编号：CHARGE_TURNOVER_TYPE）
     * @see ChargeConstant.TurnoverType
     */
    private String turnoverType;

    /**
     * 变更前余额
     */
    private BigDecimal quotaBeforeChange;

    /**
     * 变更余额
     */
    private BigDecimal quotaChange;

    /**
     * 变更后余额
     */
    private BigDecimal quotaAfterChange;

    /**
     * 下单时间
     */
    private LocalDateTime orderTime;

    /**
     * 充电开始时间
     */
    private LocalDateTime chargeStartTime;

    /**
     * 充电结束时间
     */
    private LocalDateTime chargeEndTime;

    /**
     * 结算时间
     */
    private LocalDateTime settleTime;


    /**
     * 来源小程序miniAppId
     */
    private String miniAppId;

    /**
     * 来源平台
     */
    private String sourcePlatform;

    /**
     * 来源平台名称
     */
    @TableField(exist = false)
    private String sourcePlatformName;


    /**
     * 状态
     * @see ChargeConstant.ProcessStatus
     */
    private String status;

    /**
     * 创建人
     */
    private String createUser;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 生效日期
     */
    @TableField(exist = false)
    private LocalDateTime effctiveDate;

    /**
     * 失效日期
     */
    @TableField(exist = false)
    private LocalDateTime expireDate;

}
