package com.rocogz.syy.charge.client;

import com.rocogz.syy.charge.dto.ExpireRefundNotifyDto;
import com.rocogz.syy.charge.dto.RechargeSuccessNotifyDto;
import com.rocogz.syy.charge.dto.TurnoverSearchDto;
import com.rocogz.syy.charge.dto.UserChargedNotifyDto;
import com.rocogz.syy.charge.entity.*;
import com.rocogz.syy.common.PageTable;
import com.rocogz.syy.common.response.Response;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.math.BigDecimal;
import java.util.List;

/**
 * The interface Charge c client service.
 */
public interface IChargeCClientService {

    /**
     * 根据手机号和类型获取对应的账户信息
     * @param mobile
     * @param type
     * @return
     */
    @GetMapping("/api/charge/account/info")
    Response<ChargeAccount> getChargeAccount(@RequestParam(name = "mobile")String mobile, @RequestParam(name = "type") String type);

    /**
     * 根据卡号获取对应的账户信息
     * @param code 卡号
     */
    @GetMapping("/api/charge/account/getByCode")
    Response<ChargeAccount> getChargeAccountByCode(@RequestParam(name = "code")String code);

    /**
     * 新增或更新账户信息
     * @param account
     * @return
     */
    @PostMapping("/api/charge/account/addOrUpdate")
    Response addOrUpdateChargeAccount(@RequestBody ChargeAccount account);

    /**
     * 根据条件分页查询流水
     * @param searchDto
     * @return
     */
    @GetMapping("/api/charge/turnover/list")
    PageTable<ChargeTurnover> selectChargeTurnoverList(@SpringQueryMap TurnoverSearchDto searchDto);

    /**
     * 根据流水编号获取流水详情信息
     * @param code
     * @return
     */
    @GetMapping("/api/charge/turnover/getByCode")
    Response<ChargeTurnover> getTurnoverByCode(@RequestParam(name = "code") String code);

    /**
     * 新增流水
     * @param turnover
     * @return
     */
    @PostMapping("/api/charge/turnover/add")
    Response addChargeTurnover(@RequestBody ChargeTurnover turnover);

    /**
     * 根据流水号 更新交易金额
     * @param turnover
     * @return
     */
    @PostMapping("/api/charge/turnover/updateTradeAmtByTurnoverCode")
    Response updateTradeAmtByTurnoverCode(@RequestBody ChargeTurnover turnover);

    /**
     * 根据流水号查询对应的明细
     * @param turnoverCode
     * @return
     */
    @GetMapping("/api/charge/detail/getByTurnoverCode")
    Response<List<ChargeDetail>> selectChargeDetailByTurnoverCode(@RequestParam(name = "turnoverCode") String turnoverCode);

    /**
     * 根据流水号查询对应的明细
     * @param turnoverCode  流水号
     * @return 只返回一条数据
     */
    @GetMapping("/api/charge/detail/getOneByTurnoverCode")
    Response<ChargeDetail> getOneChargeDetailByTurnoverCode(@RequestParam(name = "turnoverCode") String turnoverCode);

    @GetMapping("/api/charge/order/refund")
    Response refundOrder(@RequestParam(name = "orderCode") String orderCode,@RequestParam(name = "refundTurnoverCode")String refundTurnoverCode,@RequestParam(name = "createUser")String createUser);

    @PostMapping("/api/charge/order/rechargedSuccessNotify")
    Response rechargedSuccessNotify(@RequestBody RechargeSuccessNotifyDto notifyDto);

    @PostMapping("/api/charge/order/expiredRefundNotify")
    Response<ChargeDetail> expiredRefundNotify(@RequestBody ExpireRefundNotifyDto notifyDto);

    @PostMapping("/api/charge/order/userChargedNotify")
    Response<ChargeDetail> userChargedNotify(@RequestBody UserChargedNotifyDto notifyDto);

    @GetMapping("/api/charge/process/getChargeProcessByOrderCode")
    Response<ChargeProcess> getChargeProcessByOrderCode(@RequestParam(name = "orderCode") String orderCode);

    @PostMapping("/api/charge/process/saveChargeProcess")
    Response saveChargeProcess(@RequestBody ChargeProcess chargeProcess);

    @GetMapping("/api/charge/detail/listByOrderItemCode")
    Response<List<ChargeDetail>> listByOrderItemCode(@RequestParam(name = "orderItemCodeList") List<String> orderItemCodeList);

    /**
     * 根据条件分页查询客户流水
     * @param searchDto
     * @return
     */
    @GetMapping("/api/charge/customer/turnover/list")
    PageTable<CustomerChargeTurnover> selectList(@SpringQueryMap TurnoverSearchDto searchDto);

    /**
     * 根据流水编号获取客户流水详情信息
     * @param code
     * @return
     */
    @GetMapping("/api/charge/customer/turnover/getByCode")
    Response<CustomerChargeTurnover> getByCode(@RequestParam(name = "code") String code);


    /**
     * 新增客户流水
     * @param turnover
     * @return
     */
    @PostMapping("/api/charge/customer/turnover/add")
    Response addCustomerTurnover(@RequestBody CustomerChargeTurnover turnover);

    /**
     * 根据客户订单号获取客户充值/后台发放流水详情信息
     * @param customerOrderCode
     * @return
     */
    @GetMapping("/api/charge/customer/turnover/getChargeTurnoverByCustomerCode")
    Response<CustomerChargeTurnover> getChargeTurnoverByCustomerCode(@RequestParam(name = "customerOrderCode") String customerOrderCode);

}
