package com.rocogz.syy.charge.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotEmpty;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * <dl>
 * <dd>Description: </dd>
 * <dd>Company: 大诚若谷信息技术有限公司</dd>
 * <dd>@date：2023/3/02 16:30</dd>
 * <dd>@author：陈煜敏</dd>
 * </dl>
 */
@Data
@Accessors(chain = true)
@ApiModel("充值成功通知")
public class RechargeSuccessNotifyDto {
    /**
     * 分销订单编号
     */
    @ApiModelProperty("分销订单编号")
    @NotEmpty
    private String scmOrderCode;

    /**
     * 分销明细订单编号
     */
    @ApiModelProperty("分销明细订单编号")
    @NotEmpty
    private String scmOrderItemCode;

    /**
     * 批次号
     */
    @ApiModelProperty("批次号")
    private String batchNo;

    /**
     * 业务单号
     */
    @ApiModelProperty("业务单号")
    private String businessCode;

    /**
     * 订单编号
     */
    @ApiModelProperty("订单编号")
    private String orderCode;

    /**
     * 卡号
     */
    @ApiModelProperty("卡号")
    private String cardCode;

    /**
     * 流水号
     */
    @ApiModelProperty("流水号")
    private String turnoverCode;

    /**
     * 手机号
     */
    @ApiModelProperty("手机号")
    private String mobile;

    /**
     * 类型（积分、直发）
     */
    @ApiModelProperty("类型（积分、直发）")
    private String type;

    /**
     * 充值金额
     */
    @ApiModelProperty("充值金额")
    private BigDecimal amt;

    /**
     * 小程序AppId
     */
    @ApiModelProperty("小程序AppId")
    private String miniAppId;

    /**
     * 有效期开始日期
     */
    @ApiModelProperty("有效期开始日期")
    private LocalDateTime validityPeriodStartTime;

    /**
     * 有效期结束日期
     */
    @ApiModelProperty("有效期结束日期")
    private LocalDateTime validityPeriodEndTime;

    /**
     * 操作人
     */
    @ApiModelProperty("操作人")
    private String userCode;

    /**
     * 来源平台
     */
    @ApiModelProperty("来源平台")
    private String sourcePlatform;

    /**
     * 下游订单号（客户订单号）
     */
    @ApiModelProperty("下游订单号（客户订单号）")
    private String customerOrderCode;

    /**
     * 平台产品编号
     */
    @ApiModelProperty("平台产品编号")
    private String platformGoodsCode;

    /**
     * 实际与三方平台的交易金额
     */
    @ApiModelProperty("实际与三方平台的交易金额")
    private BigDecimal tradeAmt;


}
