package com.rocogz.syy.charge.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotEmpty;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * <dl>
 * <dd>Description: </dd>
 * <dd>Company: 大诚若谷信息技术有限公司</dd>
 * <dd>@date：2023/3/02 16:30</dd>
 * <dd>@author：陈煜敏</dd>
 * </dl>
 */
@Data
@Accessors(chain = true)
@ApiModel("用户充电结果通知")
public class UserChargedNotifyDto {

    /**
     * 南方电网订单编号
     */
    @ApiModelProperty("南方电网订单编号")
    private String orderCode;

    /**
     * 卡号
     */
    @ApiModelProperty("卡号")
    private String cardCode;

    /**
     * 充值流水号
     */
    @ApiModelProperty("充值流水号")
    private String serialNo;

    /**
     * 新的流水号
     */
    @ApiModelProperty("新的流水号")
    private String turnoverCode;

    /**
     * 业务单号
     */
    @ApiModelProperty("业务单号")
    private String businessCode;

    /**
     * 手机号
     */
    @ApiModelProperty("手机号")
    private String mobile;

    /**
     * 金额(补收，退款金额传正数)
     */
    @ApiModelProperty("金额(补收，退款金额传正数)")
    private BigDecimal amt;

    /**
     * 变动类型 03-订单消费，04-订单补收，05-订单退款
     */
    @ApiModelProperty("变动类型 03-订单消费，04-订单补收，05-订单退款")
    private String changeType;


    /**
     * 下单时间
     */
    @ApiModelProperty("下单时间")
    private LocalDateTime applyTime;

    /**
     * 充电开始时间
     */
    @ApiModelProperty("充电开始时间")
    private LocalDateTime bgnTime;

    /**
     * 充电结束时间
     */
    @ApiModelProperty("充电结束时间")
    private LocalDateTime endTime;

    /**
     * 结算时间
     */
    @ApiModelProperty("结算时间")
    private LocalDateTime settlementTime;

    /**
     * 每次请求唯一标识，如果相同标识则为同个请求，20位，同个订单号可能有多个订单类型
     */
    @ApiModelProperty("每次请求唯一标识")
    private String commandId;

}
