package com.rocogz.syy.charge.dto;

import lombok.Data;

/**
 * @Description: C端充电流水信息查询dto
 * @date：2023/02/27
 * @author：
 */
@Data
public class TurnoverSearchDto {

    /**
     * 流水号
     */
    private String code;

    /**
     * 批次号
     */
    private String batchNo;

    /**
     * 卡号
     */
    private String accountCode;

    /**
     * 类型列表（以逗号分割）
     */
    private String turnoverType;

    /**
     * 订单编号
     */
    private String orderCode;

    /**
     * 客户订单号
     */
    private String customerOrderCode;

    /**
     * 发放会员手机号
     */
    private String grantMobile;

    /**
     * 平台产品编号
     */
    private String platformGoodsCode;

    /**
     * 状态
     */
    private String status;

    /**
     * 创建时间-开始
     */
    private String createTimeStart;

    /**
     * 创建时间-结束
     */
    private String createTimeEnd;

    /**
     * 当前页
     */
    private int page = 1;

    /**
     * 每页记录数
     */
    private int limit = 10;
}
