/*
 * Decompiled with CFR 0.152.
 */
package com.rocogz.syy.charge.client;

import com.rocogz.syy.charge.dto.ExpireRefundNotifyDto;
import com.rocogz.syy.charge.dto.RechargeSuccessNotifyDto;
import com.rocogz.syy.charge.dto.TurnoverSearchDto;
import com.rocogz.syy.charge.dto.UserChargedNotifyDto;
import com.rocogz.syy.charge.entity.ChargeAccount;
import com.rocogz.syy.charge.entity.ChargeDetail;
import com.rocogz.syy.charge.entity.ChargeProcess;
import com.rocogz.syy.charge.entity.ChargeTurnover;
import com.rocogz.syy.charge.entity.CustomerChargeTurnover;
import com.rocogz.syy.common.PageTable;
import com.rocogz.syy.common.response.Response;
import java.math.BigDecimal;
import java.util.List;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

public interface IChargeCClientService {
    @GetMapping(value={"/api/charge/account/info"})
    public Response<ChargeAccount> getChargeAccount(@RequestParam(name="mobile") String var1, @RequestParam(name="type") String var2);

    @GetMapping(value={"/api/charge/account/getByCode"})
    public Response<ChargeAccount> getChargeAccountByCode(@RequestParam(name="code") String var1);

    @PostMapping(value={"/api/charge/account/addOrUpdate"})
    public Response addOrUpdateChargeAccount(@RequestBody ChargeAccount var1);

    @GetMapping(value={"/api/charge/turnover/list"})
    public PageTable<ChargeTurnover> selectChargeTurnoverList(@SpringQueryMap TurnoverSearchDto var1);

    @GetMapping(value={"/api/charge/turnover/getByCode"})
    public Response<ChargeTurnover> getTurnoverByCode(@RequestParam(name="code") String var1);

    @PostMapping(value={"/api/charge/turnover/add"})
    public Response addChargeTurnover(@RequestBody ChargeTurnover var1);

    @PostMapping(value={"/api/charge/turnover/updateTradeAmtByTurnoverCode"})
    public Response updateTradeAmtByTurnoverCode(@RequestBody ChargeTurnover var1);

    @GetMapping(value={"/api/charge/detail/getByTurnoverCode"})
    public Response<List<ChargeDetail>> selectChargeDetailByTurnoverCode(@RequestParam(name="turnoverCode") String var1);

    @GetMapping(value={"/api/charge/detail/getOneByTurnoverCode"})
    public Response<ChargeDetail> getOneChargeDetailByTurnoverCode(@RequestParam(name="turnoverCode") String var1);

    @GetMapping(value={"/api/charge/order/refund"})
    public Response refundOrder(@RequestParam(name="orderCode") String var1, @RequestParam(name="refundTurnoverCode") String var2, @RequestParam(name="tradeAmt") BigDecimal var3, @RequestParam(name="createUser") String var4);

    @PostMapping(value={"/api/charge/order/rechargedSuccessNotify"})
    public Response rechargedSuccessNotify(@RequestBody RechargeSuccessNotifyDto var1);

    @PostMapping(value={"/api/charge/order/expiredRefundNotify"})
    public Response<ChargeDetail> expiredRefundNotify(@RequestBody ExpireRefundNotifyDto var1);

    @PostMapping(value={"/api/charge/order/userChargedNotify"})
    public Response<ChargeDetail> userChargedNotify(@RequestBody UserChargedNotifyDto var1);

    @GetMapping(value={"/api/charge/process/getChargeProcessByOrderCode"})
    public Response<ChargeProcess> getChargeProcessByOrderCode(@RequestParam(name="orderCode") String var1);

    @PostMapping(value={"/api/charge/process/saveChargeProcess"})
    public Response saveChargeProcess(@RequestBody ChargeProcess var1);

    @GetMapping(value={"/api/charge/detail/listByOrderItemCode"})
    public Response<List<ChargeDetail>> listByOrderItemCode(@RequestParam(name="orderItemCodeList") List<String> var1);

    @GetMapping(value={"/api/charge/customer/turnover/list"})
    public PageTable<CustomerChargeTurnover> selectList(@SpringQueryMap TurnoverSearchDto var1);

    @GetMapping(value={"/api/charge/customer/turnover/getByCode"})
    public Response<CustomerChargeTurnover> getByCode(@RequestParam(name="code") String var1);

    @PostMapping(value={"/api/charge/customer/turnover/add"})
    public Response addCustomerTurnover(@RequestBody CustomerChargeTurnover var1);

    @GetMapping(value={"/api/charge/customer/turnover/getChargeTurnoverByCustomerCode"})
    public Response<CustomerChargeTurnover> getChargeTurnoverByCustomerCode(@RequestParam(name="customerOrderCode") String var1);

    @GetMapping(value={"/api/charge/customer/turnover/getChargeTurnoverByCustomerCodeAndTurnoverType"})
    public Response<List<CustomerChargeTurnover>> getChargeTurnoverByCustomerCodeAndTurnoverType(@RequestParam(name="customerOrderCode") String var1, @RequestParam(name="turnoverTypeList") List<String> var2);
}

