package com.rocogz.syy.charge.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * <dl>
 * <dd>Description: 过期退款通知DTO</dd>
 * <dd>Company: 大诚若谷信息技术有限公司</dd>
 * <dd>@date：2023/3/02 16:30</dd>
 * <dd>@author：陈煜敏</dd>
 * </dl>
 */
@Data
@Accessors(chain = true)
@ApiModel("过期退款DTO")
public class ExpireRefundNotifyDto {

    /**
     * 预生成流水号，插入过期退款数据使用
     */
    @ApiModelProperty("预生成流水号")
    private String turnoverCode;

    /**
     * 流水号
     */
    @ApiModelProperty("流水号")
    private String serialNo;

    /**
     * 分销订单编号
     */
    @ApiModelProperty("分销订单编号")
    @NotEmpty
    private String scmOrderCode;

    /**
     * 分销明细订单编号
     */
    @ApiModelProperty("分销明细订单编号")
    @NotEmpty
    private String scmOrderItemCode;

    /**
     * 南网退款金额
     */
    @ApiModelProperty("南网退款金额")
    @NotNull
    private BigDecimal refund;

}
