package com.rocogz.syy.charge.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.charge.constant.ChargeConstant;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * @Description: C端充电充值记录表
 * @date：2023/02/27
 * @author：
 */
@Data
@Accessors(chain = true)
@TableName("charge_process")
public class ChargeProcess extends IdEntity {

    /**
     * 上游订单号
     */
    private String orderCode;

    /**
     * 下游订单号（客户订单号）
     */
    private String customerOrderCode;

    /**
     * 充值流水号
     */
    private String turnoverCode;

    /**
     * 充值手机号
     */
    private String mobile;

    /**
     * 充值额度
     */
    private BigDecimal amt;

    /**
     * 充值卡号
     */
    private String cardNo;

    /**
     * 充值状态
     * @see ChargeConstant.ProcessStatus
     */
    private String status;

    /**
     * 充值时间
     */
    private LocalDateTime chargeTime;

    /**
     * 完成时间
     */
    private LocalDateTime completeTime;

}
