/*
 * Decompiled with CFR 0.152.
 */
package com.rocogz.syy.common.web.converter;

import java.text.ParseException;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import javax.validation.ValidationException;
import org.apache.commons.lang3.time.DateUtils;
import org.springframework.core.convert.converter.Converter;
import org.springframework.util.StringUtils;

public class LocalDateTimeConverter
implements Converter<String, LocalDateTime> {
    String[] dateTimePatterns = new String[]{"yyyy-MM-dd HH:mm:ss", "yyyy/MM/dd HH:mm:ss", "yyyy-MM-dd HH:mm", "yyyy/MM/dd HH:mm", "yyyy\u5e74MM\u6708dd\u65e5 HH:mm:ss", "yyyy\u5e74MM\u6708dd\u65e5 HH:mm"};

    public LocalDateTime convert(String source) {
        if (StringUtils.isEmpty((Object)source)) {
            return null;
        }
        try {
            Date date = DateUtils.parseDate((String)source, (String[])this.dateTimePatterns);
            return LocalDateTime.ofInstant(Instant.ofEpochMilli(date.getTime()), ZoneId.systemDefault());
        }
        catch (ParseException ex) {
            throw new ValidationException("\u65e5\u671f\u65f6\u95f4\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u8f93\u5165\u7684\u65e5\u671f\u65f6\u95f4\u662f\uff1a" + source);
        }
    }
}

