package com.rocogz.syy.common.tencent.resp;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.rocogz.syy.common.tencent.DistrictArea;

/**
 * Created by zhangmin on 2020/4/07.
 * 根据 经纬度 查询 地址信息 返回结果
 */
@JsonIgnoreProperties(ignoreUnknown = true)
public class QQLocationResp extends QQMapBaseResp {

    private LocationResult result;

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static class LocationResult extends LngLatDistrict {

        @Override
        @JsonProperty("address_component")
        public void setDistrict(DistrictArea district) {
            this.district = district;
        }

    }


    public LocationResult getResult() {
        return result;
    }

    public void setResult(LocationResult result) {
        this.result = result;
    }
}
